/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.basex.util.Array;
import org.basex.util.Util;
import org.basex.util.list.ElementList;

public class StringList
extends ElementList
implements Iterable<String> {
    protected String[] list;

    public StringList() {
        this(8);
    }

    public StringList(int c) {
        this.list = new String[c];
    }

    public final void add(String e) {
        if (this.size == this.list.length) {
            this.list = Array.copyOf(this.list, this.newSize());
        }
        this.list[this.size++] = e;
    }

    public final String get(int p) {
        return this.list[p];
    }

    public final boolean contains(String e) {
        int i = 0;
        while (i < this.size) {
            if (this.list[i].equals(e)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final void delete(int i) {
        Array.move(this.list, i + 1, -1, --this.size - i);
    }

    public final void delete(String e) {
        int s = this.size - 1;
        while (s >= 0) {
            if (this.list[s].equals(e)) {
                this.delete(s);
            }
            --s;
        }
    }

    public final String[] toArray() {
        return Array.copyOf(this.list, this.size);
    }

    public final void sort(boolean cs, boolean asc) {
        this.sort(cs, asc, 0);
    }

    public final void sort(boolean cs, boolean asc, int pos) {
        Comparator comp = cs ? null : String.CASE_INSENSITIVE_ORDER;
        Arrays.sort(this.list, pos, this.size, asc ? comp : Collections.reverseOrder(comp));
    }

    @Override
    public final Iterator<String> iterator() {
        return new Iterator<String>(){
            private int c = -1;

            @Override
            public boolean hasNext() {
                return ++this.c < StringList.this.size;
            }

            @Override
            public String next() {
                return StringList.this.list[this.c];
            }

            @Override
            public void remove() {
                Util.notexpected(new Object[0]);
            }
        };
    }
}

