#!/bin/bash -eE
                  #// Content-Type: text/plain; charset=utf-8
                  #// -eE オプションは、エラーが起きたら中断します
                  #// -x オプションは、１行ずつコマンドを表示します

g_AllArguments="$@"
g_FuncName=${1#--*}  #// cut -- from $1

function  Main_func()
{
  local  AppKey="$2" ; AppKeyClass.newWritable_method  "$AppKey"  "$PWD"
  if [ "$g_FuncName" == "" ]; then
    echo  "関数一覧："
    echo  T_Sudo_func
    echo  T_Install_func
    Error_func  "呼び出すスクリプト内の関数を指定してください。例 $BASH_SOURCE --T_Test1_func"
  fi
  $g_FuncName  "$@"
  ColorText_func  "Pass."  "Green" "Bold" ; echo_e_func  "$g_Ret"
}


 
#//*********************************************************************
#// <<< [T_Sudo_func] >>>
#//*********************************************************************
function  T_Sudo_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}
  local  exit_code
  local  AppKey="$2" ; AppKeyClass.newWritable_method  "$AppKey"  "$PWD/_T_Sudo_func.txt"


  #//=== Basic Test

  #// set up
  if [ -e "_T_Sudo_func.txt" ]; then  Error_func  _T_Sudo_func.txt を削除してください。  ;fi
  echo  "a" | sudo tee  _T_Sudo_func.txt

  #// Test Main : access denied
  echo  "次の質問では、削除を選ばないでください"
  exit_code="0"
  rm  "_T_Sudo_func.txt"  || exit_code="$?" && if [ "$exit_code" == "0" ];then  exit_code="99"  ;fi
  if [ "$exit_code" == "0" ]; then  Error_func  "Error exptected ($exit_code)"  ;fi
  echo "This error is OK"

  if [ ! -e "_T_Sudo_func.txt" ]; then  Error_func  ;fi

  #// Test Main
  sudo_func rm_func  "_T_Sudo_func.txt"
  if [ -e "_T_Sudo_func.txt" ]; then  Error_func  ;fi
}


 
#//*********************************************************************
#// <<< [T_Install_func] >>>
#//*********************************************************************
function  T_Install_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}

  local  AppKey="$2" ; AppKeyClass.enableInstall_method  "$AppKey"

  IsMac_func ; if [ "$g_Ret" == "1" ];then
    echo  "Macでは、Install_func は使えません。"
    return
  fi

  local  symbol
  local  default_pack="lha-sjis"
  local  a1

  echo  "Enterのみ： $default_pack"
  Input_func  "テストに使うインストールされていない Debianパッケージ名 >"
  symbol="$g_Ret"
  if [ "$symbol" == "" ];then  symbol="$default_pack"  ;fi

  IsInstalled_func  "$symbol"
  if [ "$g_Ret" == "1" ];then
    a1="すでにインストールされているため別のパッケージを指定してください。"
    a1="${a1}アンインストール：sudo apt-get remove $symbol"
    Error_func  "$a1"
  fi

  sudo_func  InstallIfNot_func  "$symbol"

  IsInstalled_func  "$symbol"
  Assert_func  '"$g_Ret" == "1"'

  g_IsEnableInstall3192=0  #// This is not API
  sudo_func  InstallIfNot_func  "$symbol"
  AppKeyClass.enableInstall_method  "$AppKey"

  sudo_func  InstallIfNot_func  "$symbol"
  sudo_func  Uninstall_func  "$symbol"

  IsInstalled_func  "$symbol"
  Assert_func  '"$g_Ret" == "0"'


  g_IsEnableInstall3192=0  #// This is not API

  while TryStart_func; do
    sudo_func  InstallIfNot_func  "$symbol"
  TryEnd1_func; done ;TryEnd2_func $?
  if [ "$g_ExitStatus" == "0" ]; then  Error_func  "Error exptected"  ;fi
  echo "${g_Err_Desc}${LF}This error is OK";  ErrClass.clear_method

  while TryStart_func; do
    sudo_func  Uninstall_func  "$symbol"
  TryEnd1_func; done ;TryEnd2_func $?
  if [ "$g_ExitStatus" == "0" ]; then  Error_func  "Error exptected"  ;fi
  echo "${g_Err_Desc}${LF}This error is OK";  ErrClass.clear_method
}


 







#//--- start of bashlib include ------------------------------------------------------ 

#// <<< set up bashlib and call Main_func >>> 

#// bashlib is provided under 3-clause BSD license.
#// Copyright (C) 2011 Sofrware Design Gallery "Sage Plaisir 21" All Rights Reserved.

g_BashLibPath="scriptlib/bashlib_inc.sh"; g_Ver="1.0"
g_StartInPath=`pwd`; cd "`dirname "$BASH_SOURCE"`"; g_Arguments=( "$BASH_SOURCE" "$@" )
for (( i = 0; i < 20; i ++ ));do
  if [ -e "$g_BashLibPath" ];then break ;else  g_BashLibPath="../$g_BashLibPath" ;fi ;done
if [ "$i" == "20" ];then  echo "${g_BashLibPath##*../} が見つかりません。
bashlib $g_Ver をダウンロードして scriptlib フォルダーをコピーしてください。"; exit 1 ;fi
source  "$g_BashLibPath"  #// include
CallMain_func
#//--- end of bashlib include --------------------------------------------------------
 
