unit Unit2;

interface

uses
  SysUtils, Classes, HTTPApp, StrUtils, HTTPProd, DSProd, OleServer,
  ASGSQLite3, DB;

type
  TWebModule2 = class(TWebModule)
    DataSetPageProducer1: TDataSetPageProducer;
    PageProducer2: TPageProducer;
    DataSetPageProducer2: TDataSetPageProducer;
    PageProducer1: TPageProducer;
    ASQLite3DB1: TASQLite3DB;
    ASQLite3Table1: TASQLite3Table;
    ASQLite3Log1: TASQLite3Log;
    DataSource1: TDataSource;
    ASQLite3Query1: TASQLite3Query;
    ASQLite3UpdateSQL1: TASQLite3UpdateSQL;
    procedure WebModuleCreate(Sender: TObject);
    procedure WebModuleDestroy(Sender: TObject);
    procedure WebModuleBeforeDispatch(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebModule2WebActionItem1Action(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebModuleAfterDispatch(Sender: TObject; Request: TWebRequest;
      Response: TWebResponse; var Handled: Boolean);
    procedure PageProducer2HTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
    procedure WebModule2WebActionItem5Action(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure DataSetPageProducer2HTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
    procedure DataSetPageProducer1HTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
    procedure WebModule2WebActionItem6Action(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure PageProducer1HTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
    procedure WebModule2WebActionItem3Action(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
  private
    { Private declarations }
    title1, title2: string;
    head, body, foot: string;
    admin_pass: string;
    htmlw: Boolean;
    html_file: string;
    home: string;
    page_def: integer;
    max, maxn, maxs, maxv: integer;
    maxline: integer;
    w_regist: integer;
    autolink, tag: Boolean;
    mudai: string;
    re_color: string;
    hostview: integer;
    no_host, no_word: TStringList;
  public
    { Public declarations }
  end;

const
    GAIBU: Boolean = true;
    LOCKEY: integer = 1;
    LOCK: string = 'lock/plock';

var
  WebModule2: TWebModule2;

implementation

uses WebReq, Unit3;

{$R *.DFM}

procedure TWebModule2.WebModuleCreate(Sender: TObject);
begin
//* <title>ɓ^Cg */
        title1 := 'P-BBS';
//* fTOP^CgiHTMLj*/
        title2 := '<font size=5 face=Verdana color=gray><b>P-BBS</b></font>';
//* <body>^O */
        body := '<body bgcolor="#ddf2ed" text="#444444" link="#0000AA">';
//* ǗҗppX[hBKύXĉB*/
        admin_pass := 'full';

//* TOPy[WHTMLɏo iyes=1 no=0j*/
        htmlw := true;
//* ÓIHTMLoꍇHTMLt@C */
        html_file := 'pbbs.html';

//* ߂iHOMEj*/
        home := 'http://hogehoge.com';
//* y[W̕\L */
        page_def := 10;
//* őL^ zƌÂߋOֈڂ܂B*/
        max := 30;
//* iOA薼A{jSpƂ̔ł */
        maxn  := 40;
        maxs  := 40;
        maxv  := 1500;
//* {̉s */
        maxline := 25;
//* zXg̘Ae𐧌
//  --> bLqƂ̎Ԉȏo߂ȂƘAełȂ*/
        w_regist := 30;
//* ŎN邩ǂiyes=1 no=0j*/
        autolink := true;
//* HTML^OLɂ邩iyes=1 no=0)*/
        tag := true;
//* ^Cgœeꂽꍇ */
        mudai := '()';
//* ̐F */
        re_color := '#225588';
//* zXg\邩i\Ȃ=0 <!-->ŕ\=1 \=2j*/
        hostview := 1;
//* O݋֎~ɂ?(=1,Ȃ=0) */
//define("GAIBU", 0);

//* gpt@CbÑ^Cvimkdir=1 flock=2 gȂ=0j*/
//define("LOCKEY", 2); 		//ʏ2OK
//* mkdirbNglockƂŃfBNg쐬777ɂĂ */
//define("LOCK" , "lock/plock");	//lock̒ɍ郍bNt@C
        no_host:=TStringList.Create;
        no_host.CommaText:='"kantei.go.jp","anonymizer.com","pt$","ph$","my$","th$","rr.com"';
        no_word:=TStringList.Create;
        no_word.CommaText:='"","n","novapublic"';
end;

procedure TWebModule2.WebModuleDestroy(Sender: TObject);
begin
        no_host.Free;
        no_word.Free;
end;

procedure TWebModule2.WebModuleBeforeDispatch(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  i: integer;
begin
{
  if ASQLite3DB1.TableExists('pbbs') = false then
  begin
        ASQLite3Query1.Active:=true;
        ASQLite3Query1.Active:=false;
  end;
        ASQLite3Table1.TableName:='pbbs';
      }
        ASQLite3Table1.Active:=true;
        home:='http://'+Request.Host+Request.InternalScriptName;
        head:='<html><head><META HTTP-EQUIV="Content-type" CONTENT="text/html; charset=Shift_JIS"><title>'+
                title1+'</title></head>';
        foot:='[ <a href='+home+'>z[</a> ] [ <a href='+home+'/admin>Ǘ</a> ]'+
                '<br><br><small><!-- P-BBS v1.232 -->- <a href="http://php.s3.to" target="_top">P-BBS</a> -</small>'+
                '</body></html>';
  for i:=0 to no_host.Count-1 do
  begin
    if AnsiContainsText(Request.URL,no_host[i]) = true then
    begin
        Response.StatusCode:=204;
        break;
    end;
  end;
end;

procedure TWebModule2.WebModule2WebActionItem1Action(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
  if (Request.InternalPathInfo = '/')or(Request.InternalPathInfo = '') then
  begin
        Response.Content:=PageProducer2.Content;
  end else
  begin
        Response.StatusCode:=404;
        Response.Content:='404 Not Found';
  end;
end;

procedure TWebModule2.WebModuleAfterDispatch(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
        ASQLite3Table1.Active:=false;
end;

procedure TWebModule2.PageProducer2HTMLTag(Sender: TObject; Tag: TTag;
  const TagString: String; TagParams: TStrings; var ReplaceText: String);
var
  count: integer;
  s: string;
begin
  if TagString = 'max' then
  begin
        ReplaceText:=IntToStr(max);
  end;
  if TagString = 'page_def' then
  begin
        ReplaceText:=IntToStr(page_def);
  end;
  if TagString = 'home' then
  begin
        ReplaceText:=home;
  end;
  if TagString = 'main' then
  begin
        count:=0;
        s:='';
        ASQLite3Table1.First;
    while (ASQLite3Table1.Eof = false)and(count < max) do
    begin
        s:=s+DataSetPageProducer2.Content;
        ASQLite3Table1.Next;
        inc(count);
    end;
        ReplaceText:=s;
  end;
  if TagString = 'title2' then
  begin
        ReplaceText:=title2;
  end;
  if TagString = 'foot' then
  begin
        ReplaceText:=foot;
  end;
end;

procedure TWebModule2.WebModule2WebActionItem5Action(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  i: integer;
  s, name, pass, sub, com: string;
  procedure linecount;
  var
    j: integer;
    temp: TStringList;
  begin
        temp:=TStringList.Create;
    try
        temp.Text:=com;
      if temp.Count > maxline then
      begin
                s:=s+'s܂'#13#10;
      end else
      begin
                com:='';
        for j:=0 to temp.Count-1 do
        begin
                com:=com+'<br>'+temp[j];
        end;
      end;
    finally
        temp.Free;
    end;
  end;
  procedure cookie;
  begin
    with Response.Cookies.Add do
    begin
        Name:='name';
        Value:=Request.Authorization;
    if Value = '' then
    begin
        Value:=Request.CookieFields.Values['name'];
    end;
        Secure:=true;
        Expires:=Now+20;
    end;
  end;
begin
        s:='';
  if Request.Method <> 'POST' then
  begin
        s:=s+'sȓeȂł'#13#10;
  end;
  if (GAIBU = true)and(false) then
  begin
        s:=s+'O珑݂ł܂'#13#10;
  end;
        name:=Request.ContentFields.Values['name'];
        sub:=Request.ContentFields.Values['sub'];
        com:=Request.ContentFields.Values['com'];
        pass:=Request.ContentFields.Values['password'];
  if name = '' then
  begin
        name:='no name';
  end else
        if Length(name) > maxn then
  begin
        s:=s+'O܂'#13#10;
  end;
  if sub = '' then
  begin
        sub:=mudai;
  end else
        if Length(sub) > maxs then
  begin
        s:=s+'^Cg܂'#13#10;
  end;
  if com = '' then
  begin
        s:=s+'{܂Ă܂'#13#10;
  end else
        if Length(com) > maxv then
  begin
        s:=s+'{܂'#13#10;
  end;
  for i:=0 to no_word.Count-1 do
  begin
    if (AnsiContainsText(com,no_word[i]) = true)or(AnsiContainsText(sub,no_word[i]) = true)or
      (AnsiContainsText(name,no_word[i]) = true) then
    begin
        s:=s+'gpłȂt܂܂Ă܂'#13#10;
    end;
  end;
        linecount;
        cookie;
  if s <> '' then
  begin
        Response.Content:=head+s+foot;
  end else
  begin
        ASQLite3Table1.Last;
        i:=ASQLite3Table1.FieldByName('no').AsInteger;
    if i > 0 then
    begin
        inc(i);
    end;
        ASQLite3Table1.AppendRecord([pass,i,Now,name,sub,com]);
        Response.SendRedirect(home);
  end;
end;

procedure TWebModule2.DataSetPageProducer2HTMLTag(Sender: TObject;
  Tag: TTag; const TagString: String; TagParams: TStrings;
  var ReplaceText: String);
begin
  if TagString = 'now' then
  begin
        ReplaceText:=DateToStr(ASQLite3Table1.FieldByName('date').AsFloat);
  end else
  begin
        ReplaceText:=ASQLite3Table1.FieldByName(TagString).AsString;
  end;
end;

procedure TWebModule2.DataSetPageProducer1HTMLTag(Sender: TObject;
  Tag: TTag; const TagString: String; TagParams: TStrings;
  var ReplaceText: String);
begin
  if TagString = 'home' then
  begin
        ReplaceText:=home;
  end else
        if TagString = 'now' then
  begin
        ReplaceText:=DateTimeToStr(ASQLite3Table1.FieldByName('date').AsFloat);
  end else
  begin
        ReplaceText:=ASQLite3Table1.FieldByName(TagString).AsString;
  end;
end;

procedure TWebModule2.WebModule2WebActionItem6Action(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  s, t: string;
  x: Boolean;
  no, pwd: string;
begin
        no:=Request.ContentFields.Values['no'];
        pwd:=Request.ContentFields.Values['pwd'];
  if (no = '')or(pwd = '') then
  begin
        t:='폜no܂͍폜L[͂ł';
  end;
        s:='';
        x:=false;
  with ASQLite3Table1 do
  begin
        First;
  while Eof = false do
  begin
    if FieldByName('no').AsString = no then
    begin
        s:=ASQLite3Table1.FieldByName('pass').AsString;
        x:=true;
        break
    end;
        Next;
  end;
  end;
  if x = true then
  begin
    if s = '' then
    begin
        t:='YLɂ͍폜L[ݒ肳Ă܂)';
    end else
        if s <> pwd then
    begin
        t:='폜L[Ⴂ܂';
    end;
  end else
  begin
        t:='YL܂';
  end;
  if t <> '' then
  begin
        Response.Content:=head+t+foot;
  end else
  begin
        s:=Request.ContentFields.Values['no'];
    with ASQLite3Table1 do
    begin
        First;
    while Eof = false do
    begin
      if s = FieldByName('no').AsString then
      begin
                Delete;
                break;
      end;
        Next;
    end;
    end;
        Response.SendRedirect(home);
  end;
end;

procedure TWebModule2.PageProducer1HTMLTag(Sender: TObject; Tag: TTag;
  const TagString: String; TagParams: TStrings; var ReplaceText: String);
var
  count: integer;
begin
  if TagString = 'home' then
  begin
        ReplaceText:=home;
  end;
  if TagString = 'main' then
  begin
    with ASQLite3Table1 do
    begin
        count:=0;
        First;
    while (Eof = false)and(count < max) do
    begin
        ReplaceText:=ReplaceText+DataSetPageProducer1.Content;
        Next;
        inc(count);
    end;
    end;
  end;
end;

procedure TWebModule2.WebModule2WebActionItem3Action(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  i: integer;
  s: string;
begin
  for i:=0 to Request.QueryFields.Count-1 do
  begin
        s:=Request.QueryFields.Values[Request.QueryFields.Names[i]];
    with ASQLite3Table1 do
    begin
        First;
    while Eof = false do
    begin
      if s = FieldByName('no').AsString then
      begin
                Delete;
                break;
      end else
      begin
                Next;
      end;
    end;
    end;
  end;
        Response.SendRedirect(home);
end;

initialization
  if WebRequestHandler <> nil then
    WebRequestHandler.WebModuleClass := TWebModule2;

end.
