#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>

#include "bc9-leds-jni.h"
#include "bc9-leds.h"
  
//  cleanup function prototype.
static int cleanup(JNIEnv *env, int fd);

JNIEXPORT jboolean JNICALL
Java_com_beatcraft_demos_leds_BC9Leds_Light(JNIEnv *env,
                                            jobject obj,
                                            jintArray array)
{
    struct bc9_leds_onoff_t onoff;

    //   bc9_leds driver's open syscall does not
    //   return error.
    int fd = open("/dev/bc9_leds", O_WRONLY);
    if (fd == -1) {
        cleanup(env, fd);
        jclass exception = (*env)->FindClass(env,
                                "java/io/IOException"
                           );
        if (exception == NULL) {
            return JNI_FALSE;
        }
        (*env)->ThrowNew(env, exception, strerror(errno));    
    }

    int count, result = 0;
    jint buf[4];
    
    //   get arguments.
    (*env)->GetIntArrayRegion(env, array, 0, 4, buf);
    onoff.led1_onoff = buf[0];
    onoff.led2_onoff = buf[1];
    onoff.led3_onoff = buf[2];
    onoff.led4_onoff = buf[3];

    //   finally we switch leds [on|off].
    result = ioctl(fd, BC9_LEDS_IOCTL_ONOFF, &onoff);
    ioctl(fd, BC9_LEDS_IOCTL_ONOFF, &onoff);
    if (result == -1) {
        cleanup(env, fd);
        jclass exception = (*env)->FindClass(env,
                                "java/io/IOException"
                           );
        if (exception == NULL) {
            return JNI_FALSE;
        }
        (*env)->ThrowNew(env, exception, strerror(errno));    
    }

    cleanup(env, fd);
    return JNI_TRUE;
}

static int cleanup(JNIEnv *env, int fd)
{
    int result = 0;
    result = close(fd);
    if (result == -1) {
         jclass exception = (*env)->FindClass(env,
                                "java/io/IOException"
                           );
        if (exception == NULL) {
            return -1;
        }
        (*env)->ThrowNew(env, exception, strerror(errno));    
    } 
    return 0;
}
