package com.beatcraft.demos.leds;

import java.io.IOException;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.util.Log;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.SeekBar.OnSeekBarChangeListener;

public class BC9Leds extends Activity {
	
	private String BC9LEDS_LOG_LABEL = "BC9LEDS";
    private BC9LedsThread thread;
    private int[] light_state = {0, 0, 0, 0};
    
    /*
     *  Color definition
     */
    private static final int SELECTED_TEXT_COLOR = Color.BLACK;
    private static final int UNSELECTED_TEXT_COLOR = Color.WHITE;
    private static final int SELECTED_COLOR = Color.CYAN;
    private static final int UNSELECTED_COLOR = Color.BLACK;
    
    /*
     *  native method to switch on|off leds.
     */
    public static native boolean Light(int[] params) throws IOException;
    static {
    	System.loadLibrary("bc9-leds");
    }
    
    /*
     *  widgets
     */
    private CheckBox chk1;
    private CheckBox chk2;
    private CheckBox chk3;
    private CheckBox chk4;
    private RadioButton radio;
    private TextView interval_text;
    private SeekBar seekbar;
    private LinearLayout right_side;
    
    
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        Log.i(BC9LEDS_LOG_LABEL, "Oncreate Called");
        
        //    initialize randam led thread
        thread = new BC9LedsThread(this);
        
        allLightsOff();
        
        //    checkbox event setting.
        BC9LEDCheckListener ledcheck = new BC9LEDCheckListener();
    	chk1 = (CheckBox)findViewById(R.id.CheckBox01);
    	chk1.setOnCheckedChangeListener(ledcheck);
    	chk2 = (CheckBox)findViewById(R.id.CheckBox02);
    	chk2.setOnCheckedChangeListener(ledcheck);
    	chk3 = (CheckBox)findViewById(R.id.CheckBox03);
    	chk3.setOnCheckedChangeListener(ledcheck);
    	chk4 = (CheckBox)findViewById(R.id.CheckBox04);
    	chk4.setOnCheckedChangeListener(ledcheck);
    	
    	//   radio button event setting
    	radio = (RadioButton)findViewById(R.id.RadioButton01);
    	radio.setOnCheckedChangeListener(new BC9LEDRandomCheckListener());

    	//   seekbar size and event setting
    	interval_text = (TextView)findViewById(R.id.TextView01);
    	interval_text.setTextColor(UNSELECTED_TEXT_COLOR);
    	
    	seekbar = (SeekBar)findViewById(R.id.SeekBar01);
    	seekbar.setEnabled(false);
    	seekbar.setOnSeekBarChangeListener(new BC9SeekBarListener());
    	
    	right_side = (LinearLayout)findViewById(R.id.LinearLayout02);
    }
    
    public void onStop()
    {
    	Log.i(BC9LEDS_LOG_LABEL, "onStop Called");
    	super.onStop();
    	thread.must_stop = true;
    	allLightsOff();
    }
    
    public void onDestroy()
    {
    	Log.i(BC9LEDS_LOG_LABEL, "onDestroy Called");
    	super.onDestroy();
    	thread.must_stop = true;
    	allLightsOff();
    }
    
    public void onRestart()
    {
    	Log.i(BC9LEDS_LOG_LABEL, "onRestart Called");
    	super.onRestart();
    	thread.must_stop = true;
    	try{
    		if (thread.isstarted) {
    		    thread.join();  //  if not stop, wait for stopping.
    		}
    	} catch (InterruptedException e) {
            Log.e(BC9LEDS_LOG_LABEL, e.getMessage());
    	}
    	
    	thread = new BC9LedsThread(this);
    	int lights_interval = (seekbar.getProgress() * 9) + 100;
    	thread.lights_interval = lights_interval;
    	if (radio.isChecked()) {
        	Log.i(BC9LEDS_LOG_LABEL, "Thread restarting ... : muststop -> " + thread.must_stop);
        	thread.start();
    	} else {
    		Log.i(BC9LEDS_LOG_LABEL, "Thread not started because radio did not checked");
 			try {
				BC9Leds.Light(light_state);
			} catch(IOException e) {
				Log.e(BC9LEDS_LOG_LABEL, e.getMessage());
			}
    	}
    }

    private void allLightsOff()
    {
    	Log.i(BC9LEDS_LOG_LABEL, "all LEDS WILL BE TURNED OFF");
    	int[] lights = { 0,0,0,0 };
        try {
        	BC9Leds.Light(lights);
        } catch (IOException e) {
        	Toast.makeText(this, e.getMessage(), Toast.LENGTH_LONG);
        	e.printStackTrace();
        }    	
    }
    
    private class BC9SeekBarListener implements OnSeekBarChangeListener
    {
		public void onProgressChanged(SeekBar seekBar, int progress,
				boolean fromUser) {
			if (fromUser) {
				Log.i(BC9LEDS_LOG_LABEL, "Progressbar changed:" + progress);
				int lights_interval = (progress * 9) + 100;
				thread.lights_interval = lights_interval;
			}
		}

		public void onStartTrackingTouch(SeekBar seekBar) {
			Log.i(BC9LEDS_LOG_LABEL, "Progressbar start tracking touch");
			return;
		}

		public void onStopTrackingTouch(SeekBar seekBar) {
			Log.i(BC9LEDS_LOG_LABEL, "Progressbar end tracking touch");
			return;
		}
    }
    
    private class BC9LEDCheckListener implements OnCheckedChangeListener
    {
		public void onCheckedChanged(CompoundButton buttonView,
				boolean isChecked) {
			
			//    radio and checkboxes are exclusive each other.
			if (isChecked) {
				radio.setChecked(false);
				buttonView.setTextColor(SELECTED_TEXT_COLOR);
				buttonView.setBackgroundColor(SELECTED_COLOR);

			} else {
				buttonView.setTextColor(UNSELECTED_TEXT_COLOR);
				buttonView.setBackgroundColor(UNSELECTED_COLOR);
			}
			interval_text.setTextColor(UNSELECTED_TEXT_COLOR);
			right_side.setBackgroundColor(UNSELECTED_COLOR);
			
			//    while radio button checked, uncheck event run. 
			//    in this case, we must not stop thread.
			if (!radio.isChecked() && isChecked) {
			    thread.must_stop = true;
    	    	try{
	        		if (thread.isstarted) {
	    	    	    thread.join();  //  if not stop, wait for stopping.
	    	    	}
	        	} catch (InterruptedException e) {
	                Log.e(BC9LEDS_LOG_LABEL, e.getMessage());
	        	}
			    thread = new BC9LedsThread(buttonView.getContext());
			}
			
			//    lights each leds
			String tag = buttonView.getTag().toString();
			int idx = Integer.valueOf(tag);
			light_state[idx] = (isChecked) ? 1 : 0;
			String debug_label = (isChecked) ? " checked" : " unchecked";
			Log.e(BC9LEDS_LOG_LABEL, "LED" + (idx + 1) + debug_label);
			
			try {
				BC9Leds.Light(light_state);
			} catch(IOException e) {
				Log.e(BC9LEDS_LOG_LABEL, e.getMessage());
			}
		}	
    }

    private class BC9LEDRandomCheckListener implements OnCheckedChangeListener
    {
		public void onCheckedChanged(CompoundButton buttonView,
				boolean isChecked) {
			
			seekbar.setEnabled(isChecked);
            if (isChecked) {
            	radio.setChecked(true);
            	
            	Log.e(BC9LEDS_LOG_LABEL, "RADIO BUTTON checked");
            	if (!thread.isstarted) {
            	    thread.start();
            	}
            	
            	int lights_interval = (seekbar.getProgress() * 9) + 100;
            	thread.lights_interval = lights_interval;
            	
            	chk1.setChecked(false);
            	chk2.setChecked(false);
            	chk3.setChecked(false);
            	chk4.setChecked(false);
				buttonView.setTextColor(SELECTED_TEXT_COLOR);
				interval_text.setTextColor(SELECTED_TEXT_COLOR);
				right_side.setBackgroundColor(SELECTED_COLOR);
            } else {
				buttonView.setTextColor(UNSELECTED_TEXT_COLOR);
				interval_text.setTextColor(UNSELECTED_TEXT_COLOR);
				right_side.setBackgroundColor(UNSELECTED_COLOR);
            }
		}	
    }
      
    private class BC9LedsThread extends Thread implements Runnable
    {
    	public boolean isstarted = false;
    	public boolean must_stop = false;
    	public int lights_interval = 100;  // 0.1 seconds
    	private Context context;
    	private String BC9LEDS_THREAD_LOG = "BC9LEDS_THREAD";
    	
    	public BC9LedsThread(Context _context)
    	{
    		this.context = _context;
    	}
    	
    	public void run()
    	{
    		isstarted = true;
    		Log.i(BC9LEDS_THREAD_LOG, "BC9Ledsthread started");
 		    this.lightsRandom();
 		    Log.i(BC9LEDS_THREAD_LOG, "BC9LedsThread stopped");
    	}
    	
        private void lightsRandom()
        {
            for(int i = 0; i < 100000; i++) {
            	int[] lights =
            	{
            		(i >> 0) & 1,
            		(i >> 1) & 1,
            		(i >> 2) & 1,
            		(i >> 3) & 1,        		
            	};
                try {
                	BC9Leds.Light(lights);
                    Thread.sleep(lights_interval);  // 0.5 second
                } catch (IOException e) {
                	Toast.makeText(context, e.getMessage(), Toast.LENGTH_LONG);
                	e.printStackTrace();
                } catch (InterruptedException e1) {
                	Toast.makeText(context, e1.getMessage(), Toast.LENGTH_LONG);
                	e1.printStackTrace();
                }
                if (must_stop) {
                	Log.i(BC9LEDS_THREAD_LOG, "BC9LedsThread break");
                	allLightsOff();
                	break;
                }
            }
        }
    }
}
