/**
 *    accelerometer dump program without android.
 *
 *    gcc -Wall -I/path/to/bc9-kernel-source/include -o acceldump acceldump.c
 */

#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <linux/bc9-accelerometer.h>

#define DLOG(fmt, ...) printf(fmt "\n", ##__VA_ARGS__)

static void timeval_difftime(const char *label, struct timeval *before, struct timeval *after)
{
    long long int before_usec = before->tv_sec * 1000000 + before->tv_usec;
    long long int after_usec = after->tv_sec * 1000000 + after->tv_usec;
    DLOG("%s: %.5f sec", label, (double)(after_usec - before_usec) / 1000000);
}

static void init_accel(int fd, int gsel)
{
	int ret;
	struct bc9_accelerometer_conf conf;

	memset(&conf, 0x0, sizeof(struct bc9_accelerometer_conf));
	ret = ioctl(fd, BC9_ACCELEROMETER_GETCONF, &conf);
	if (ret == -1) {
		perror("GETCONF");
		return;
	}
	conf.enable = 1;
	conf.gselect = gsel;
	ret = ioctl(fd, BC9_ACCELEROMETER_SETCONF, &conf);
	if (ret == -1) {
		perror("SETCONF");
		return;
	}
}

static void dump_accel(int fd, int id)
{
	int ret;
	struct bc9_accelerometer_data accel;
        struct timeval tval, tval1;
        //struct timespec tspec, tspec1;

	memset(&accel, 0x0, sizeof(struct bc9_accelerometer_data));

        gettimeofday(&tval, NULL); 
	ret = ioctl(fd, BC9_ACCELEROMETER_GETDATA, &accel);
        gettimeofday(&tval1, NULL); 

	if (ret == -1) {
		perror("GETDATA");
		return;
	}

        timeval_difftime("ioctl", &tval, &tval1);
	DLOG("dump fd%d ( %d, %d, %d )", id, accel.x, accel.y, accel.z);
}

static void dump_loop(int fd, int id)
{
    int count = 0;

    while (1) {
       if (count == 10) {
           break; 
       }
       dump_accel(fd, id);
       count++;
    }
    return;
}

int main(int argc, char* argv[])
{
	int fd;
	int max;
	int gsel = BC9_ACCELEROMETER_GSEL_1500;

	DLOG("acceldump start...");

	if (argc > 1) {
		max = strtol(argv[1], NULL, 10);
		switch (max) {
		case 2000:
			gsel = BC9_ACCELEROMETER_GSEL_2000;
			break;
		case 3000:
			gsel = BC9_ACCELEROMETER_GSEL_3000;
			break;
		case 6000:
			gsel = BC9_ACCELEROMETER_GSEL_6000;
			break;
		default:
			gsel = BC9_ACCELEROMETER_GSEL_1500;
			break;
		}
	}

	fd = open("/dev/accelerometer", O_RDWR);
	if (fd == -1) {
	    perror("open");
            return 1;
	}
        init_accel(fd, gsel);
        dump_loop(fd, 1);

        close(fd);
	return 0;
}
