package com.beatcraft.demos.bc9sensorapp;

/**
 *  This code was taken referenced from sample code in the following blogs.
 *  http://www.grandnature.net/blog/archives/2009/02/android_2.html
 */
import java.util.List;

import com.beatcraft.demos.bc9sensorapp.R;

import android.app.Activity;
import android.graphics.Color;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.TextView;

public class BC9SensorAppActivity extends Activity implements SensorEventListener {
    
	private static final String LOG_TAG = "BC9SensorAppActivity";
	
	View layout;
    TextView accelerometerValue;
    TextView orientationValue;
    TextView filteredAccelerationValue;
    TextView filteredOrientationValue;
    TextView magneticValue;
    TextView orientation;
    SensorManager sensorManager;
    
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        // --- views
        setContentView(R.layout.main);
        layout = findViewById(R.id.layout);
        accelerometerValue = (TextView)findViewById(R.id.accelerometer_value);
        magneticValue = (TextView)findViewById(R.id.magnetic_value);
        orientationValue = (TextView)findViewById(R.id.orientation_value);
        orientation = (TextView)findViewById(R.id.orientation);
        // --- sensors
        sensorManager = (SensorManager) getSystemService(SENSOR_SERVICE);
    }
    @Override
    protected void onStop() {
        sensorManager.unregisterListener(this);
        super.onStop();
    }
    
    @Override
    protected void onResume() {
        super.onResume();

        List<Sensor> sensorList = sensorManager.getSensorList(Sensor.TYPE_ALL);
        if (sensorList != null && sensorList.size() > 0) { 
            for (int i = 0; i < sensorList.size(); i++) {
            	Log.i(LOG_TAG, "sensor found! -> " + sensorList.get(i).getName() );
        	    sensorManager.registerListener(this, sensorList.get(i), SensorManager.SENSOR_DELAY_NORMAL);
            }    
        } else {
        	Log.e(LOG_TAG, "sensor NOT FOUND!");
        }
    }

    public void onSensorChanged(SensorEvent event) {

		int sensorType = event.sensor.getType();
	
		switch (sensorType) {
		case Sensor.TYPE_ACCELEROMETER:
		    Log.i(LOG_TAG, "Sensor Type: ACCELEROMETER");
        	accelerometerValue.setText(convertFloatsToString(event));

            float targetValue = 
                Math.abs(event.values[0]) + 
                Math.abs(event.values[1]) +
                Math.abs(event.values[2]);
            if(targetValue > 22.0f) 
                layout.setBackgroundColor(Color.YELLOW);
            else 
                layout.setBackgroundColor(Color.BLACK);
            
            if(Math.abs(event.values[0]) > 7.0f) {
                orientation.setText("横");
            } else if(Math.abs(event.values[1]) > 7.0f) {
                orientation.setText("縦");
            } else if(Math.abs(event.values[2]) > 7.0f) {
                orientation.setText("水平");
            } else {
                orientation.setText("");
            }
		    break;
		case Sensor.TYPE_GYROSCOPE:
		    Log.i(LOG_TAG, "Sensor Type: GYROSCOPE");
		    break;
		case Sensor.TYPE_ORIENTATION:
		    Log.i(LOG_TAG, "Sensor Type: ORIENTATION");
		    orientationValue.setText(convertFloatsToString(event));
		    break;
		case Sensor.TYPE_LIGHT:
		    Log.i(LOG_TAG, "Sensor Type: LIGHT");
		    break;
		case Sensor.TYPE_MAGNETIC_FIELD:
		    Log.i(LOG_TAG, "Sensor Type: MAGNETIC_FIELD");
		    magneticValue.setText(convertFloatsToString(event));        	
		    break;
		case Sensor.TYPE_PRESSURE:
		    Log.i(LOG_TAG, "Sensor Type: PRESSURE");
		    break;
		case Sensor.TYPE_PROXIMITY:
		    Log.i(LOG_TAG, "Sensor Type: PROXIMITY");
		    break;
		case Sensor.TYPE_TEMPERATURE:
		    Log.i(LOG_TAG, "Sensor Type: TEMPERATURE");
		    break;
		default:
			Log.i(LOG_TAG, "Sensor Type: UNKNOWN");
		}
    }
    private String convertFloatsToString(SensorEvent event) {
    	System.out.println("time: " + event.timestamp);
    	System.out.println("value0: " + event.values[0]);
    	System.out.println("value1: " + event.values[1]);
    	System.out.println("value2: " + event.values[2]);
    	
        return 
        Float.toString(event.values[0]) + ", " + 
        Float.toString(event.values[1]) + ", " + 
        Float.toString(event.values[2]);
        
    }

    public void onAccuracyChanged(Sensor arg0, int arg1) {
        // TODO Auto-generated method stub
    }

}
