package jp.sf.beanbinder.annotations;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;

import jp.sf.beanbinder.BeanBinder;
import jp.sf.beanbinder.BindProperty;
import jp.sf.beanbinder.BindingBridge;
import jp.sf.beanbinder.CellRenderer;
import jp.sf.beanbinder.MappingParser;
import jp.sf.beanbinder.editor.CellEditor;
import jp.sf.beanbinder.listener.EditListener;
import jp.sf.beanbinder.validator.Validator;

public final class AnnotationParser implements MappingParser {
    private Object target;
    private BindingBridge bridge;
    private BeanBinder binder;
    
    public AnnotationParser(BeanBinder binder, Object target) {
        this.target = target;
        this.binder = binder;
    }
    
    public void parse() {
        this.bridge = new BindingBridge(this.binder, this.target);
        
        //フィールドの取得
        List<Field> results = new ArrayList<Field>(); 
        parseFields( results, target.getClass() );
        Field[] fields = results.toArray(new Field[]{});
        AccessibleObject.setAccessible(fields, true); 
        
        try {
            for(Field field : fields) {
                parseAnnotation(target, field);
            }
        }catch(Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }
    private void parseFields(List<Field> fields, Class currentClass) {
        if( currentClass == null )return;
        Field[] fs = currentClass.getDeclaredFields();
        for(Field f : fs) {
            fields.add(f);
        }
        parseFields(fields, currentClass.getSuperclass());
    }
    private void parseAnnotation(Object target, Field field) throws Exception {
        //Basic
        jp.sf.beanbinder.annotations.Basic basic = field.getAnnotation(jp.sf.beanbinder.annotations.Basic.class);
        if( basic != null ){ basic(target, field, basic); }
        
        //Custom
        jp.sf.beanbinder.annotations.Custom custom = field.getAnnotation(jp.sf.beanbinder.annotations.Custom.class);
        if( custom != null ){ custom(target, field, custom); }
        
        //Select
        jp.sf.beanbinder.annotations.Select select = field.getAnnotation(jp.sf.beanbinder.annotations.Select.class);
        if( select != null ){ select(target, field, select); }
        
        //Table
        jp.sf.beanbinder.annotations.Table table = field.getAnnotation(jp.sf.beanbinder.annotations.Table.class);
        if( table != null ){ table(target, field, table); }
    }
    
    private jp.sf.beanbinder.IMEMode getIMEMode(IMEMode imeMode) {
        if( imeMode == null )return jp.sf.beanbinder.IMEMode.DEFAULT;
        if( imeMode.equals(IMEMode.DEFAULT) )return jp.sf.beanbinder.IMEMode.DEFAULT;
        if( imeMode.equals(IMEMode.JP) )return jp.sf.beanbinder.IMEMode.JP;
        if( imeMode.equals(IMEMode.HALFKANA) )return jp.sf.beanbinder.IMEMode.HALFKANA;
        return null;
    }
    private jp.sf.beanbinder.AlignType getHorizon(AlignType align) {
        if( align.equals(AlignType.LEFT) )return jp.sf.beanbinder.AlignType.LEFT;
        if( align.equals(AlignType.RIGHT) )return jp.sf.beanbinder.AlignType.RIGHT;
        if( align.equals(AlignType.CENTER) )return jp.sf.beanbinder.AlignType.CENTER;
        if( align.equals(AlignType.TOP) )return jp.sf.beanbinder.AlignType.TOP;
        if( align.equals(AlignType.BOTTOM) )return jp.sf.beanbinder.AlignType.BOTTOM;
        
        return jp.sf.beanbinder.AlignType.LEFT;
    }
    private jp.sf.beanbinder.AlignType getVertical(AlignType align) {
        if( align.equals(AlignType.LEFT) )return jp.sf.beanbinder.AlignType.LEFT;
        if( align.equals(AlignType.RIGHT) )return jp.sf.beanbinder.AlignType.RIGHT;
        if( align.equals(AlignType.CENTER) )return jp.sf.beanbinder.AlignType.CENTER;
        if( align.equals(AlignType.TOP) )return jp.sf.beanbinder.AlignType.TOP;
        if( align.equals(AlignType.BOTTOM) )return jp.sf.beanbinder.AlignType.BOTTOM;
        
        return jp.sf.beanbinder.AlignType.TOP;
    }
    
    //@Table
    private void table(Object target, Field field, jp.sf.beanbinder.annotations.Table table) throws Exception {        
        List<BindProperty> columns = new ArrayList<BindProperty>();
        for(int i=0; i<table.columns().length; i++) {
            Column col = table.columns()[i];
            BindProperty prop = this.bridge.bindColumn(col.displayProp(), col.valueProp(), col.idProp(),
                    col.text(), col.readOnly(), col.prop(),
                    col.width(),
                    this.getIMEMode(col.imeMode()),
                    (Format)this.bridge.getFieldValue(target, col.formatField()),
                    this.getHorizon(col.horizon()),
                    this.getVertical(col.vertical()),
                    (Validator)this.bridge.getFieldValue(target, col.validatorField()),
                    (CellEditor)this.bridge.getFieldValue(target, col.cellEditorField()),
                    (CellRenderer)this.bridge.getFieldValue(target, col.cellRendererField())
            );
            columns.add(prop);
        }
        this.bridge.bindTable(field.getName(), table.objectKey(),
                table.group(), table.rowHeight(), table.sortable(),
                (EditListener)this.bridge.getFieldValue(target, table.editListenerField()),
                columns.toArray(new BindProperty[]{})
        );
    }
    //@Basic
    private void basic(Object target, Field field, jp.sf.beanbinder.annotations.Basic basic) throws Exception {        
        bridge.bindBasic(field.getName(), basic.objectKey(), basic.prop(), basic.group(),
                this.getIMEMode(basic.imeMode()),
                (Format)this.bridge.getFieldValue(target, basic.formatField()),
                this.getHorizon(basic.horizon()),
                this.getVertical(basic.vertical()),
                (Validator)this.bridge.getFieldValue(target, basic.validatorField())
        );
    }
    //@Custom
    private void custom(Object target, Field field, jp.sf.beanbinder.annotations.Custom custom) throws Exception {
        this.bridge.bindCustom(field.getName(), custom.objectKey(), custom.displayProp(), custom.idProp(),
                custom.group(),
                this.getIMEMode(custom.imeMode()),
                (Format)this.bridge.getFieldValue(target, custom.formatField()),
                this.getHorizon(custom.horizon()),
                this.getVertical(custom.vertical()),
                (Validator)this.bridge.getFieldValue(target, custom.validatorField())
        );
    }
    //@Select
    private void select(Object target, Field field, jp.sf.beanbinder.annotations.Select select) throws Exception {
        bridge.bindSelect(field.getName(), select.group(),
                select.destKey(), select.destValueProp(), select.destIdProp(),
                select.srcKey(), select.srcDisplayProp(), select.srcValueProp(), select.srcIdProp(),
                (Format)this.bridge.getFieldValue(target, select.formatField()),
                this.getHorizon(select.horizon()),
                this.getVertical(select.vertical()),
                (Validator)this.bridge.getFieldValue(target, select.validatorField())
        );
    }
}
