package jp.sf.beanbinder.annotations;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

@Target({FIELD})
@Retention(RUNTIME)
public @interface Custom {
    public String objectKey();
    public String displayProp() default "";
    public String idProp() default "";
    public String group() default "";
    
    public IMEMode imeMode() default IMEMode.DEFAULT;
    public AlignType horizon() default AlignType.LEFT;
    public AlignType vertical() default AlignType.TOP;
    public String validatorField() default "";
    public String formatField() default "";
}
