package jp.sf.beanbinder;

import java.util.ArrayList;
import java.util.List;

import jp.sf.beanbinder.listener.EditListener;

/**
 * コンポーネントとオブジェクトの関連付を表現します
 */
public final class Bind {
    private String name;
    private String target;
    private String dataSource;
    private String group="";
    private Object component;
    private List bindProperties = new ArrayList();//List<BindProperty>
    private boolean enable=true;
    private boolean sortable=false;
    private EditListener editListener;
    
    public Bind(String target, Object component) {
        this.target = target;
        this.dataSource = target;
        this.component = component;
    }
    public String getDataSource() {
        return dataSource;
    }
    public void setDataSource(String datasource) {
        this.dataSource = datasource;
    }
    public Object getComponent() {
        return component;
    }
    public void setComponent(Object component) {
        this.component = component;
    }
    public String getTarget() {
        return target;
    }
    public void setTarget(String target) {
        this.target = target;
    }
    public List getProperties() {
        return bindProperties;
    }
    public void setProperties(List bindProperties) {
        this.bindProperties = bindProperties;
    }
    public BindProperty addProperty(BindProperty property) {
        this.bindProperties.add(property);
        return property;
    }
    public void removeProperty(BindProperty property) {
        this.bindProperties.remove(property);
    }
    public BindProperty getProperty(int index) {
        return (BindProperty)this.bindProperties.get(index);
    }
    public boolean isEnable() {
        return enable;
    }
    public void setEnable(boolean enable) {
        this.enable = enable;
    }
    public String getGroup() {
        return group;
    }
    public void setGroup(String group) {
        this.group = group;
    }
    public boolean isSortable() {
        return sortable;
    }
    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public EditListener getEditListener() {
        return editListener;
    }
    public void setEditListener(EditListener editListener) {
        this.editListener = editListener;
    }
    
}
