package jp.sf.beanbinder;

import java.text.Format;

import jp.sf.beanbinder.validator.DefaultValidator;
import jp.sf.beanbinder.validator.Validator;

/**
 * バインド要素
 * @author Tomohiro Umeda
 */
public final class BindProperty {
    private String displayProperty;
    private Ref ref;
    private Ref dataSrc;
    private Validator validator = new DefaultValidator();
    private ColumnProperty columnProperty;
    private boolean isEditable=true;
    private Format format = new DefaultFormat();
    private AlignType horizon = AlignType.LEFT;
    private AlignType vertical = AlignType.TOP;
    private IMEMode imeMode = IMEMode.DEFAULT;
    private int width=100;
    private int height=20;
  
    /**
     * @param displayProp : 表示する内容を示すプロパティ名
     * @param ref : POJOプロパティ情報
     */
    public BindProperty(String displayProp, Ref ref) {
        this.displayProperty = displayProp;
        this.ref = ref;
        this.columnProperty = new ColumnProperty(null);
    }
    /**
     * @param displayProp : 表示する内容を示すプロパティ名
     * @param ref : POJOプロパティ情報
     * @param dataSrc  : データソースのプロパティ情報
     */
    public BindProperty(String displayProp, Ref ref, Ref dataSrc) {
        this.displayProperty = displayProp;
        this.ref = ref;
        this.dataSrc = dataSrc;
        this.columnProperty = new ColumnProperty(null);
    }
    public boolean isEditable() {
        return isEditable;
    }
    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }
    public Format getFormat() {
        return format;
    }
    public void setFormat(Format format) {
        this.format = format;
    }
    public AlignType getHorizon() {
        return horizon;
    }
    public void setHorizon(AlignType horizon) {
        this.horizon = horizon;
    }
    public AlignType getVertical() {
        return vertical;
    }
    public void setVertical(AlignType vertical) {
        this.vertical = vertical;
    }
    public ColumnProperty getColumnProperty() {
        return columnProperty;
    }
    public void setColumnProperty(ColumnProperty columnElement) {
        this.columnProperty = columnElement;
    }
    public Validator getValidator() {
        if( this.validator == null )return new DefaultValidator();
        return validator;
    }
    public void setValidator(Validator validator) {
        this.validator = validator;
    }
    /**
     * 現在設定されているIMEモードを取得
     * @return IMEMode
     */
    public IMEMode getImeMode() {
        return imeMode;
    }
    /**
     * コンポーネントのIMEモードを設定
     * @param imeMode
     */
    public void setImeMode(IMEMode imeMode) {
        this.imeMode = imeMode;
    }
    public int getHeight() {
        return height;
    }
    public void setHeight(int height) {
        this.height = height;
    }
    public int getWidth() {
        return width;
    }
    public void setWidth(int width) {
        this.width = width;
    }
    public Ref getDataSrc() {
        return dataSrc;
    }
    public void setDataSrc(Ref dataSrc) {
        this.dataSrc = dataSrc;
    }
    public Ref getRef() {
        return ref;
    }
    public void setRef(Ref ref) {
        this.ref = ref;
    }
    public String getDisplayProperty() {
        return displayProperty;
    }
    public void setDisplayProperty(String displayProperty) {
        this.displayProperty = displayProperty;
    }
}
