package jp.sf.beanbinder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import jp.sf.beanbinder.strategy.ComponentStrategy;

public abstract class BindStrategyDispatcher {
    private List componentStrategyPlugs = new ArrayList();//List<ComponentStrategyPlug>
    
    public ComponentStrategy getStrategy(Object component) {
        Iterator itr = this.getComponentStrategyPlugs().iterator();
        
        while(itr.hasNext()) {
            ComponentStrategyPlug plug = (ComponentStrategyPlug)itr.next();
            if( plug.getComponentClass().isAssignableFrom(component.getClass()) ) {
                return plug.getStrategy();
            }
        }
        ComponentStrategy cs = this.interceptor(component);
        if( cs != null )return cs;
        
        throw new RuntimeException("pass by unsupported component:"+(component==null?"null":component.getClass().getName()));
    }
    
    public ComponentStrategy interceptor(Object component) {
        return null;
    }
    
    public List getComponentStrategyPlugs() {
        return componentStrategyPlugs;
    }
    public void setComponentStrategyPlugs(List componentStrategyPlugs) {
        this.componentStrategyPlugs = componentStrategyPlugs;
    }
    public void addComponentStrategyPlug(ComponentStrategyPlug plug) {
        this.componentStrategyPlugs.add(plug);
    }
    public void removeComponentStrategyPlug(ComponentStrategyPlug plug) {
        this.componentStrategyPlugs.remove(plug);
    }
}
