package jp.sf.beanbinder;

public abstract class CellRenderer {
    private Object component;
    private BeanBinder binder;
    
    public CellRenderer(BeanBinder binder, Object component) {
        this.component = component;
        this.binder = binder;
    }
    /**
     * セルエディタの更新
     * @param displayValue
     * @param value
     * @param row
     * @param column
     * @param property
     */
    public abstract void update(BeanBinder binder, BindProperty property, Object displayValue, Object value, int row, int column);

    
    public Object getComponent(Object displayValue, Object value, boolean isSelected, boolean hasFocus, int row, int column, BindProperty property) {
        this.update(this.binder, property, displayValue, value, row, column);
        return this.component;
    }
    public BeanBinder getBinder() {
        return binder;
    }
    public void setBinder(BeanBinder binder) {
        this.binder = binder;
    }
    public Object getComponent() {
        return component;
    }
    public void setComponent(Object component) {
        this.component = component;
    }
}
