package jp.sf.beanbinder;

import jp.sf.beanbinder.editor.CellEditor;

public class ColumnProperty {
    private String text;
    private CellRenderer cellRenderer;
    private CellEditor cellEditor;
    
    public ColumnProperty(String header) {
        this.text = header;
    }
    public ColumnProperty(String header, CellEditor editor) {
        this(header);
        this.cellEditor = editor;
    }
    public ColumnProperty(String header, CellRenderer renderer) {
        this.text = header;
        this.cellRenderer = renderer;
    }
    public ColumnProperty(String header, CellRenderer renderer, CellEditor editor) {
        this(header, renderer);
        this.cellEditor = editor;
    }
    public String getText() {
        return text;
    }
    public void setText(String header) {
        this.text = header;
    }
    public CellRenderer getCellRenderer() {
        return cellRenderer;
    }
    public void setCellRenderer(CellRenderer renderer) {
        this.cellRenderer = renderer;
    }
    public CellEditor getCellEditor() {
        return cellEditor;
    }
    public void setCellEditor(CellEditor cellEditor) {
        this.cellEditor = cellEditor;
    }
}
