package jp.sf.beanbinder;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.regex.Pattern;

import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

public class ProxyInterceptor implements MethodInterceptor {
    private BeanBinder binder;
    private String objectName;
    
    public ProxyInterceptor(BeanBinder binder, String objectName) {
        this.binder = binder;
        this.objectName = objectName;
    }
    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Object result = proxy.invokeSuper(obj, args);
        
        Pattern pattern = Pattern.compile("set.*");
        if( pattern.matcher(method.getName()).matches() ) {
            Iterator itr = this.binder.bindMap.keySet().iterator();
            while(itr.hasNext()) {
                String key = (String)itr.next();
                Bind bind = (Bind)this.binder.bindMap.get(key);
                if( bind.getTarget().equals(objectName) ) {
                    this.binder.updateComponent(key);
                }
            }
        }
        return result;
    }

}
