package jp.sf.beanbinder.component.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class CalendarComponent extends JPanel {
    private static final String[] columns = new String[] { "日", "月", "火", "水", "木", "金", "土" };

    private static final String[] month = new String[] { "1月", "2月", "3月", "4月", "5月", "6月",
            "7月", "8月", "9月", "10月", "11月", "12月" };

    private Calendar calendar = null;

    private int[][] tableData;

    private JTable jTable;

    private JPanel jPanel;

    private JComboBox jComboBox;

    private JTextField jTextField;

    private JScrollBar jScrollBar;

    private Calendar result = null;

    public Calendar getResult() {
        this.update();
        return this.result;
    }

    public JTable getCalendarTable() {
        return this.jTable;
    }

    public CalendarComponent() {
        this(Calendar.getInstance(Locale.JAPAN));
    }

    public CalendarComponent(Calendar c) {
        super();

        this.jTable = new JTable();
        this.setSize(200, 300);
        this.jTable.setBounds(0, 0, 200, 280);
        this.jTable.setShowGrid(true);
        this.jTable.setShowHorizontalLines(true);
        this.jTable.setShowVerticalLines(true);
        this.jTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        this.jTable.setRowSelectionAllowed(false);
        this.jTable.setColumnSelectionAllowed(false);
        this.jTable.getTableHeader().setResizingAllowed(false);
        this.jTable.getTableHeader().setReorderingAllowed(false);

        this.jTextField = new JTextField();
        this.jTextField.setPreferredSize(new Dimension(50, 20));
        this.jTextField.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                try {
                    jScrollBar.setValue(Integer.parseInt(jTextField.getText()));
                } catch (Exception ee) {
                }
            }
        });

        this.jComboBox = new JComboBox(month);
        this.jComboBox.setPreferredSize(new Dimension(100, 20));
        this.jComboBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                update();
                buildTableData();
            }
        });

        this.jScrollBar = new JScrollBar(JScrollBar.HORIZONTAL);
        this.jScrollBar.setPreferredSize(new Dimension(25, 25));
        this.jScrollBar.setMinimum(1900);
        this.jScrollBar.setMaximum(9999);
        this.jScrollBar.addAdjustmentListener(new AdjustmentListener() {
            public void adjustmentValueChanged(AdjustmentEvent e) {
                jTextField.setText("" + e.getValue());
                update();
                buildTableData();
            }
        });

        this.jPanel = new JPanel();
        this.jPanel.setSize(300, 100);
        this.jPanel.setLayout(new BorderLayout());
        this.jPanel.add(this.jComboBox, BorderLayout.WEST);
        this.jPanel.add(this.jTextField, BorderLayout.CENTER);
        this.jPanel.add(this.jScrollBar, BorderLayout.EAST);

        this.jTable
                .setDefaultRenderer(Object.class, new PlumMVCTableRenderer());
        this.jTable.setVisible(true);
        this.jTable.addMouseListener(new MouseListener() {
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    update();
                }
            }

            public void mousePressed(MouseEvent arg0) {
            }

            public void mouseReleased(MouseEvent arg0) {
            }

            public void mouseEntered(MouseEvent arg0) {
            }

            public void mouseExited(MouseEvent arg0) {
            }
        });
        this.jTable.addKeyListener(new KeyListener() {
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == KeyEvent.VK_SPACE
                        || e.getKeyCode() == KeyEvent.VK_ENTER) {
                    update();
                }
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }
        });

        this.setLayout(new BorderLayout());
        this.add(jPanel, BorderLayout.NORTH);
        this.add(new JScrollPane(jTable), BorderLayout.CENTER);
        this.setVisible(true);

        this.calendar = c;
        this.jScrollBar.setValue(this.calendar.get(Calendar.YEAR));
        this.jTextField.setText("" + this.jScrollBar.getValue());
        this.jComboBox.setSelectedIndex(this.calendar.get(Calendar.MONTH));

        this.buildTableData();
    }

    private void buildTableData() {
        this.tableData = new int[7][6];
        int firstDay = this.calendar.getActualMinimum(Calendar.DAY_OF_MONTH);
        int endDay = this.calendar.getActualMaximum(Calendar.DAY_OF_MONTH);
        Date copy = this.calendar.getTime();
        copy.setDate(firstDay);
        this.calendar.setTime(copy);

        int firstMonth = this.calendar.get(Calendar.DAY_OF_WEEK);
        for (int i = firstDay, j = firstMonth, k = 0; i <= endDay; i++, j++) {
            copy = this.calendar.getTime();
            copy.setDate(i);
            this.calendar.setTime(copy);

            try {
                this.tableData[this.calendar.get(Calendar.DAY_OF_WEEK) - 1][k] = i;
            } catch (Exception e) {
                System.out.println("ERROR:"
                        + (this.calendar.get(Calendar.DAY_OF_WEEK) - 1) + "/"
                        + k);
            }
            if (j >= 7) {
                j = 0;
                k++;
            }
        }

        this.jTable.setModel(new CalendarTableModel());
        this.jTable.setRowSelectionInterval(0, 0);
        this.jTable.setColumnSelectionInterval(firstMonth - 1, firstMonth - 1);
        this.jTable.updateUI();
        this.jTable.revalidate();
    }

    private void update() {
        Date oldDate = this.calendar.getTime();
        this.result = null;
        try {
            if (this.jTable.getSelectedColumn() < 0)
                return;
            if (this.jTable.getSelectedRow() < 0)
                return;
            if (this.jComboBox.getSelectedIndex() < 0)
                return;

            int year = Integer.parseInt(this.jTextField.getText().trim());
            int month = this.jComboBox.getSelectedIndex() + 1;
            int day = this.tableData[this.jTable.getSelectedColumn()][this.jTable
                    .getSelectedRow()];

            if (day > 0) {
                this.calendar.setTime(new Date(year + "/" + month + "/" + day));
                this.result = Calendar.getInstance(Locale.JAPAN);
                this.result.setTime(new Date(year + "/" + month + "/" + day));
            }
        } catch (Exception e) {
            e.printStackTrace();
            this.calendar.setTime(oldDate);
        }
    }

    private class CalendarTableModel extends DefaultTableModel {
        public int getColumnCount() {
            return columns.length;
        }

        public String getColumnName(int col) {
            return columns[col];
        }

        public int getRowCount() {
            return 6;
        }

        public Object getValueAt(int row, int col) {
            if (tableData[col][row] == 0)
                return "";
            DecimalFormat df = new DecimalFormat("00");
            return df.format(tableData[col][row]);
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class PlumMVCTableRenderer extends JLabel implements TableCellRenderer {
        public PlumMVCTableRenderer() {
            super();
            setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int col) {
            if (isSelected || hasFocus) {
                setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                setForeground(table.getForeground());
                super.setBackground(table.getBackground());
            }

            this.setHorizontalAlignment(CENTER);

            setFont(table.getFont());
            setText((value == null) ? "" : value.toString());
            return this;
        }
    }
}
