package jp.sf.beanbinder.component.swing;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DateBox extends JPanel implements ActionListener {
    private Date date;
    private JTextField text;
    private JButton editButton;
    private JButton cancelButton;
    private List actionListeners = new ArrayList();//List<ActionListener>
    
    public DateBox() {
        this.setLayout(new BorderLayout());

        this.text = new JTextField();
        this.add(this.text, BorderLayout.CENTER);
        
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setPreferredSize(new Dimension(160,20));
        
        this.editButton = new JButton();
        this.editButton.setPreferredSize(new Dimension(80,20));
        this.editButton.setText("ｶﾚﾝﾀﾞｰ");
        this.editButton.addActionListener(this);
        panel.add(this.editButton, BorderLayout.WEST);
        
        this.cancelButton = new JButton();
        this.cancelButton.setPreferredSize(new Dimension(80,20));
        this.cancelButton.setText("ｷｬﾝｾﾙ");
        this.cancelButton.addActionListener(this);
        panel.add(this.cancelButton, BorderLayout.EAST);
        
        this.add(panel, BorderLayout.EAST);
    }
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }
    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    public void actionPerformed(ActionEvent e) {
        if( this.cancelButton.equals(e.getSource()) ) {
            this.date = null;
            this.text.setText("");
        }
        else {
            DateChooser c = null;
            if( this.date != null ) {
                c = new DateChooser(new GregorianCalendar(){{this.setTime(date);}});
            }else {
                c = new DateChooser();
            }
            
            Calendar ret = c.getResult();
            if( ret != null ) {
                this.date = ret.getTime();
                this.text.setText(this.date.toLocaleString().split(" ")[0]);
            }
            
            Iterator itr = this.actionListeners.iterator();
            while(itr.hasNext()) {
                ActionListener listener = (ActionListener)itr.next();
                ActionEvent event = new ActionEvent(c,0,null);
                listener.actionPerformed(event);
            }
        }
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public void setCancelButton(JButton cancelButton) {
        this.cancelButton = cancelButton;
    }

    public Date getDate() {
        try {
            this.date = new Date(this.text.getText());
        }catch(Exception e) {
            this.date = null;
        }
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
        if( this.date == null ) {
            this.text.setText("");
        }else {
            this.text.setText(this.date.toLocaleString().split(" ")[0]);
        }
    }

    public JButton getEditButton() {
        return editButton;
    }

    public void setEditButton(JButton editButton) {
        this.editButton = editButton;
    }

    public JTextField getText() {
        return text;
    }

    public void setText(JTextField text) {
        this.text = text;
    }
    
}
