package jp.sf.beanbinder.component.swing;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Calendar;
import java.util.Locale;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DateChooser extends JDialog {
    private CalendarComponent calendar;

    private JPanel jPanel;

    private Calendar result = null;

    public DateChooser() {
        this(Calendar.getInstance(Locale.JAPAN));
    }

    public DateChooser(Calendar c) {
        this.jPanel = new JPanel();
        this.jPanel.setLayout(new BorderLayout());
        JLabel label = new JLabel();
        label.setPreferredSize(new Dimension(60, 20));
        this.jPanel.add(label, BorderLayout.WEST);
        JButton ok = new JButton("決定");
        JButton cancel = new JButton("キャンセル");
        this.jPanel.add(ok, BorderLayout.CENTER);
        this.jPanel.add(cancel, BorderLayout.EAST);
        this.setAlwaysOnTop(true);

        ok.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                result = calendar.getResult();
                if (result != null) {
                    dispose();
                }
            }
        });
        cancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                result = null;
                dispose();
            }
        });

        this.setTitle("日付選択ダイアログ");
        this.setSize(250, 170);
        // this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.calendar = new CalendarComponent(c);
        this.add(this.calendar, BorderLayout.NORTH);
        this.add(this.jPanel, BorderLayout.CENTER);

        this.calendar.getCalendarTable().addKeyListener(new KeyListener() {
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == KeyEvent.VK_SPACE) {
                    result = calendar.getResult();
                    if (result != null) {
                        dispose();
                    }
                }
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.calendar.getCalendarTable().addMouseListener(new MouseListener() {
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    result = calendar.getResult();
                    if (result != null) {
                        dispose();
                    }
                }
            }

            public void mousePressed(MouseEvent arg0) {
            }

            public void mouseReleased(MouseEvent arg0) {
            }

            public void mouseEntered(MouseEvent arg0) {
            }

            public void mouseExited(MouseEvent arg0) {
            }
        });

        this.setModal(true);
        this.setVisible(true);
    }

    public Calendar getResult() {
        return this.result;
    }
}
