package jp.sf.beanbinder.component.swing;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;

import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class PictureBox extends JPanel {
    public static final int SIZEMODE_AUTO = 0;
    public static final int SIZEMODE_CENTER = 1;
    public static final int SIZEMODE_NORMAL = 2;
    public static final int SIZEMODE_STRETCH = 3;
    public static final int SIZEMODE_ZOOM = 4;
    
    private Image image;
    private String imagePath;
    private int sizeMode = SIZEMODE_NORMAL;
    
    public void setImagePath(String path) {
        this.imagePath = path;
        this.image = new ImageIcon(path).getImage();
    }
    public String getImagePath() {
        return this.imagePath;
    }
    public int getSizeMode() {
        return sizeMode;
    }
    public void setSizeMode(int sizeMode) {
        this.sizeMode = sizeMode;
    }
    public Image getImage() {
        return image;
    }
    public void setImage(Image image) {
        this.image = image;
    }
    
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR); 
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY); 
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY); 
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON); 
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE); 
        
        if( this.image == null )return;
        
        if( this.sizeMode == PictureBox.SIZEMODE_NORMAL ) {
            g2d.drawImage(this.image, 0, 0, this);
        }
        else if( this.sizeMode == PictureBox.SIZEMODE_STRETCH ) {
            g2d.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), this);
        }
        else if( this.sizeMode == PictureBox.SIZEMODE_AUTO ) {
            this.setSize(this.image.getWidth(this), this.image.getHeight(this));
            g2d.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), this);
        }
        else if( this.sizeMode == PictureBox.SIZEMODE_ZOOM ) {
            double ratio = 0;
            if( this.image.getWidth(this) > this.image.getHeight(this) ) { ratio=(double)this.getWidth()/(double)this.image.getWidth(this); }
            else { ratio=(double)this.getHeight()/(double)this.image.getHeight(this); }

            g2d.drawImage(this.image, 0, 0, (int)(this.image.getWidth(this)*ratio), (int)(this.image.getHeight(this)*ratio), this);
        }
    }
}
