package jp.sf.beanbinder.editor;

import jp.sf.beanbinder.BeanBinder;

public abstract class GeneralCellEditor extends CellEditor {
    private BeanBinder binder;
    private Object component;
    
    /**
     * @param binder : セルエディタとなるコンポーネントを登録しているBeanBinder
     * @param component : セルエディタとなるコンポーネント
     */
    public GeneralCellEditor(BeanBinder binder, Object component) {
        this.binder = binder;
        this.component = component;
    }
    
    /**
     * セルエディタの値を戻す
     * @param binder
     * @return
     */
    public abstract Object getCellEditorValue(BeanBinder binder);
    
    /**
     * セル内のオブジェクトからセルエディタの内容を
     * 変更する必要がある場合のみ実装する。
     * @param binder
     * @return
     */
    public abstract void updateCellEditor(BeanBinder binder, Object value, int row, int col);
    
    public final Object getCellEditorValue() {
        return this.getCellEditorValue(this.getBinder());
    }
    public final void updateCellEditor(Object value, int row, int col) {
        this.updateCellEditor(this.getBinder(), value, row, col);
    }
    public final Object getComponent() {
        return this.component;
    }
    public final void setComponent(Object component) {
        this.component = component;
    }
    public final BeanBinder getBinder() {
        return binder;
    }
    public final void setBinder(BeanBinder binder) {
        this.binder = binder;
    }
}
