package jp.sf.beanbinder.editor.swing;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.EventObject;

import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

import jp.sf.beanbinder.Bind;
import jp.sf.beanbinder.editor.CellEditor;
import jp.sf.beanbinder.listener.EditListenerEvent;
import jp.sf.beanbinder.strategy.swing.JTableModel;
import jp.sf.beanbinder.strategy.swing.TableSorter;
import jp.sf.beanbinder.util.BeanProcessBridge;

public class SwingCellEditor extends javax.swing.AbstractCellEditor implements TableCellEditor, CellEditorListener {
    private CellEditor cellEditor;
    private Bind bind;
    private Collection bean;
    private int clickCount = 2;
    private int currentRow=-1;
    private int currentColumn=-1;
    private Object currentValue;
    private JTableModel tableModel;
    
    public SwingCellEditor(JTableModel tableModel, Collection bean, Bind bind, CellEditor cellEditor) {
        if( cellEditor == null )throw new RuntimeException();
        if( bind == null )throw new RuntimeException();
        
        this.bean = bean;
        this.bind = bind;
        this.cellEditor = cellEditor;
        this.tableModel = tableModel;
        
        this.addCellEditorListener(this);
    }
    public Object getCellEditorValue() {
        this.currentValue = this.cellEditor.getCellEditorValue();
        return this.currentValue;
    }
    public Component getTableCellEditorComponent(final JTable table, Object value, boolean isSelected, int row, int column) {
        column = table.convertColumnIndexToModel(column);
        if( table.getModel() instanceof TableSorter ) {
            TableSorter tableSorter = (TableSorter)table.getModel();
            row = tableSorter.modelIndex(row);
        }else {
            row = table.convertRowIndexToModel(row);
        }
        this.currentRow = row;
        this.currentColumn = column;
        
        try {
            value = BeanProcessBridge.getPropertyValue(bean.toArray()[row], bind.getProperty(column).getDisplayProperty());
            
            //リスナー
            if( bind.getEditListener() != null ) {
                EditListenerEvent event = new EditListenerEvent();
                event.setRow(this.currentRow);
                event.setCol(this.currentColumn);
                event.setValue(value);
                bind.getEditListener().beginEdit(event);
            }
            
            this.cellEditor.updateCellEditor(value, row, column);
            return (Component)this.cellEditor.getComponent();
        }catch(Exception e) {
            e.printStackTrace();
            return null;
        }
    }
    public boolean isCellEditable(EventObject e) {
        if( !(e instanceof MouseEvent) )return false;
        return (((MouseEvent)e).getClickCount() >= this.clickCount);
    }
    
    public void editingCanceled(ChangeEvent e) {}
    public void editingStopped(ChangeEvent e) {
        //リスナー
        if( this.bind.getEditListener() != null && !this.tableModel.isFailedValidate ) {
            EditListenerEvent event = new EditListenerEvent();
            event.setRow(this.currentRow);
            event.setCol(this.currentColumn);
            event.setValue(this.currentValue);
            this.bind.getEditListener().endEdit(event);
        }                
    }
}
