package jp.sf.beanbinder.strategy;

import jp.sf.beanbinder.Bind;
import jp.sf.beanbinder.exception.ValidateException;
import jp.sf.beanbinder.util.BeanProcessBridge;

public abstract class AbsComponentStrategy implements ComponentStrategy {
    public void updateBean(Object bean, Bind bind, Object component) {
        Object value = this.getValue(bind, component);
        
        try {
            BeanProcessBridge.setPropertyValue(bean, bind.getProperty(0).getRef().getValueProp(), value);
        }catch(Exception e) {
            throw new RuntimeException(e);
        }
    }
    public void validate(Bind bind, Object component) throws ValidateException {
        Object value = this.getValue(bind, component);
        if( !bind.getProperty(0).getValidator().check(value, bind.getComponent()) ) {
            throw new ValidateException();
        }
    }
    /**
     * コンポーネントの編集可否設定
     */
    public void setEditable(Bind bind, Object component) {}

    /**
     * コンポーネントの構成を変更する
     */
    public void updateComponent(Bind bind, Object component) {}
}
