package jp.sf.beanbinder.strategy.swing;

import java.util.Date;

import jp.sf.beanbinder.Bind;
import jp.sf.beanbinder.component.swing.DateBox;
import jp.sf.beanbinder.strategy.AbsComponentStrategy;

public final class DateBoxStrategy extends AbsComponentStrategy {
    public void updateDisplay(Bind bind, Object component, Object value) {
        try {
            Date date = null;
            if( value instanceof Date ) {
                date = (Date)value;
            }else {
                date = new Date(value.toString());
            }
            ((DateBox)component).setDate( date );
        }catch(Exception e) {
            throw new RuntimeException(e);
        }
    }
    public void updateComponent(Bind bind, Object component) {
    }
    public void setEditable(Bind bind, Object component) {
        DateBox dateBox = (DateBox)bind.getComponent();
        dateBox.setEnabled( bind.getProperty(0).isEditable() );
    }
    public Object getValue(Bind bind, Object component) {
        DateBox dateBox = (DateBox)component;
        return dateBox.getDate();
    }
    
}
