package jp.sf.beanbinder.strategy.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;

import jp.sf.beanbinder.AlignType;
import jp.sf.beanbinder.Bind;
import jp.sf.beanbinder.BindProperty;
import jp.sf.beanbinder.CellRenderer;
import jp.sf.beanbinder.util.BeanProcessBridge;

class DefaultTableCellRenderer extends javax.swing.table.DefaultTableCellRenderer {
    private Bind bind;
    private Collection bean;
    
    public DefaultTableCellRenderer(Bind bind, Collection bean) {
        this.bind = bind;
        this.bean = bean;
    }
    public Component getTableCellRendererComponent(JTable table, Object v, boolean isSelected, boolean hasFocus, int row, int column) {
        column = table.convertColumnIndexToModel(column);
        if( table.getModel() instanceof TableSorter ) {
            TableSorter tableSorter = (TableSorter)table.getModel();
            row = tableSorter.modelIndex(row);
        }else {
            row = table.convertRowIndexToModel(row);
        }
        
        BindProperty prop = bind.getProperty(column);
        Object displayValue = null;
        Object value = null;
        
        try {
            displayValue = BeanProcessBridge.getPropertyValue(this.bean.toArray()[row], prop.getDisplayProperty());
            value = BeanProcessBridge.getPropertyValue(this.bean.toArray()[row], prop.getRef().getValueProp());
        }catch(Exception e) {
            e.printStackTrace();
        }
        
        JLabel component = (JLabel)super.getTableCellRendererComponent(table, displayValue, isSelected, hasFocus, row, column);
        CellRenderer cellRenderer = prop.getColumnProperty().getCellRenderer();
        if( cellRenderer != null ) {
            Component c = (Component)cellRenderer.getComponent(displayValue, value, isSelected, hasFocus, row, column, prop);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.setForeground(component.getForeground());
            panel.setBackground(component.getBackground());
            panel.add(c);
            return panel;
        }
        
        if( prop.getFormat() != null ) {
            try {
                component.setText( prop.getFormat().format(displayValue) );
            }catch(Exception e) {}
        }
        if( prop.getHorizon().equals(AlignType.LEFT) ) {
            component.setHorizontalAlignment(JLabel.LEFT);
        }
        else if( prop.getHorizon().equals(AlignType.CENTER) ) {
            component.setHorizontalAlignment(JLabel.CENTER);
        }
        else if( prop.getHorizon().equals(AlignType.RIGHT) ) {
            component.setHorizontalAlignment(JLabel.RIGHT);
        }
        
        return component;
    }
}
