package jp.sf.beanbinder.strategy.swing;

import java.util.Collection;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

import jp.sf.beanbinder.Bind;
import jp.sf.beanbinder.util.BeanProcessBridge;


public class JComboBoxModel extends DefaultComboBoxModel {
    public Collection bean;
    private JComboBox cmb;
    private Bind bind;
    
    public JComboBoxModel(JComboBox cmb, Collection bean, Bind bind){
        this.bean = bean;
        this.cmb = cmb;
        this.bind = bind;
    }
    public Object getElementAt(int index) {
        try {
            Object obj = BeanProcessBridge.getPropertyValue(this.bean.toArray()[index],
                    this.bind.getProperty(0).getDisplayProperty()
            );
            return this.bind.getProperty(0).getFormat().format(
                    (obj==null?"":obj.toString())
            );
        }catch(Exception e) {
            return "";
        }
    }
    public int getSize() {
        return this.bean.size();
    }
    public Object getValue(int index) {
        try {
            return BeanProcessBridge.getPropertyValue(this.bean.toArray()[index],
                    this.bind.getProperty(0).getDataSrc().getValueProp());
        }catch(Exception e) {
            return null;
        }
    }
}
