package jp.sf.beanbinder.strategy.swing;

import java.util.Collection;

import javax.swing.JComboBox;

import jp.sf.beanbinder.Bind;
import jp.sf.beanbinder.exception.ValidateException;
import jp.sf.beanbinder.strategy.ComponentStrategy;
import jp.sf.beanbinder.util.BeanProcessBridge;

public final class JComboBoxStrategy implements ComponentStrategy, SingleSelectable {

    public void updateBean(Object bean, Bind bind, Object component) {
        JComboBox cmb = (JComboBox)component;
        if( !(cmb.getModel() instanceof JComboBoxModel) )return;
        
        JComboBoxModel model = (JComboBoxModel)cmb.getModel();
        Object value = model.getValue(cmb.getSelectedIndex());
        
        if( bean instanceof Collection )return;//コレクションは更新しない
        
        try {
            BeanProcessBridge.setPropertyValue(bean, bind.getProperty(0).getRef().getValueProp(), value);
        }catch(Exception e) {
            throw new RuntimeException(e);
        }
    }
    public void validate(Bind bind, Object component) throws ValidateException {
        JComboBox c = (JComboBox)component;
        JComboBoxModel model = (JComboBoxModel)c.getModel();
        Object value = model.bean;
        
        if( !bind.getProperty(0).getValidator().check(value, c) ) {
            throw new ValidateException();
        }
    }
    public void updateDisplay(Bind bind, Object component, Object value) {
        Collection collection = (Collection)value;
        JComboBox cmb = (JComboBox)bind.getComponent();
        
        cmb.setModel(new JComboBoxModel(cmb,collection, bind));
        cmb.updateUI();
    }
    public void updateComponent(Bind bind, Object component) {
    }
    public void selectBean(Bind bind, Object component, Object[] bean) {
        JComboBox cmb = (JComboBox)component;
        JComboBoxModel model = (JComboBoxModel)cmb.getModel();
        
        for(int i=0; i<model.bean.size(); i++) {
            Object v1 = model.bean.toArray()[i];
            Object v2 = bean[0];
            try {
                v1 = BeanProcessBridge.getPropertyValue(v1, bind.getProperty(0).getDataSrc().getIdentityProp());
                v2 = BeanProcessBridge.getPropertyValue(v2, bind.getProperty(0).getRef().getIdentityProp());
            }catch(Exception e) {e.printStackTrace();}
            
            if( v1.equals(v2) ) {
                cmb.setSelectedIndex(i);
                break;
            }
        }
    }
    public Object[] getSelectedBean(Bind bind, Object component) {
        return (Object[])this.getValue(bind, component);
    }
    public void setEditable(Bind bind, Object component) {
        JComboBox cmb = (JComboBox)component;
        cmb.setEditable(bind.getProperty(0).isEditable());
    }
    public Object getValue(Bind bind, Object component) {
        JComboBox cmb = (JComboBox)component;
        JComboBoxModel model = (JComboBoxModel)cmb.getModel();
        int index = cmb.getSelectedIndex();
        if( index < 0 )return null;
        
        Object bean = model.bean.toArray()[index];
        
        try {
            return new Object[]{ BeanProcessBridge.getPropertyValue(bean, bind.getProperty(0).getDataSrc().getValueProp()) };
        }catch(Exception e) {
            throw new RuntimeException(e);
        }
    }
}
