package jp.sf.beanbinder.strategy.swing;

import java.util.Collection;

import javax.swing.DefaultListModel;
import javax.swing.JList;

import jp.sf.beanbinder.Bind;
import jp.sf.beanbinder.util.BeanProcessBridge;


public class JListBoxModel extends DefaultListModel {
    public Collection bean;
    private JList list;
    private Bind bind;
    
    public JListBoxModel(JList list, Collection bean, Bind bind){
        this.bean = bean;
        this.list = list;
        this.bind = bind;
    }
    public Object getElementAt(int index) {
        try {
            Object obj = BeanProcessBridge.getPropertyValue(this.bean.toArray()[index],
                    this.bind.getProperty(0).getDisplayProperty()
            );
            
            return bind.getProperty(0).getFormat().format(
                    (obj==null?"":obj.toString())
            );
        }catch(Exception e) {
            return "";
        }
    }
    public int getSize() {
        return this.bean.size();
    }
    public Object[] getValue(int[] indices) {
        Object[] results = new Object[indices.length];
        try {
            for(int i=0; i<indices.length; i++) {
                results[i] = BeanProcessBridge.getPropertyValue(this.bean.toArray()[indices[i]],
                        this.bind.getProperty(0).getDataSrc().getValueProp());
            }
        }catch(Exception e) {
            return null;
        }
        return results;
    }
}
