package jp.sf.beanbinder.strategy.swing;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.swing.JList;

import jp.sf.beanbinder.Bind;
import jp.sf.beanbinder.exception.ValidateException;
import jp.sf.beanbinder.strategy.ComponentStrategy;
import jp.sf.beanbinder.util.BeanProcessBridge;

import org.apache.commons.beanutils.PropertyUtils;



public final class JListBoxStrategy implements ComponentStrategy, MultiSelectable {

    public void updateBean(Object bean, Bind bind, Object component) {
        JList list = (JList)component;
        if( !(list.getModel() instanceof JListBoxModel) )return;
        
        JListBoxModel model = (JListBoxModel)list.getModel();
        Object value = model.getValue(list.getSelectedIndices());//Object[]
        
        try {
            //セット先が配列やコレクションでは無い場合
            //一つ目の要素を取り出してセットする。
            Class type = PropertyUtils.getPropertyType(bean, bind.getProperty(0).getRef().getValueProp());
            Object target = BeanProcessBridge.getPropertyValue(bean, bind.getProperty(0).getRef().getValueProp());
            
            if( !type.isArray() && !Collection.class.isAssignableFrom(type) ) {
                value = ((Object[])value)[0];
            }
            //コレクションだった場合
            else if( Collection.class.isAssignableFrom(type) ){
                //clear
                Method clearMethod = type.getMethod("clear", new Class[]{});
                Method addMethod = type.getMethod("add", new Class[]{Object.class});
                AccessibleObject.setAccessible(new Method[]{clearMethod, addMethod}, true);
                
                clearMethod.invoke(target, new Object[]{});

                //add elements
                for(int i=0; i<((Object[])value).length; i++) {
                    Object element = ((Object[])value)[i];
                    addMethod.invoke(target, new Object[]{element});
                }
                return;
            }
            
            //セット
            BeanProcessBridge.setPropertyValue(bean, bind.getProperty(0).getRef().getValueProp(), value);
        }catch(Exception e) {
            throw new RuntimeException(e);
        }
    }
    public void validate(Bind bind, Object component) throws ValidateException {
        JList c = (JList)component;
        JListBoxModel model = (JListBoxModel)c.getModel();
        Object value = model.bean;
        
        if( !bind.getProperty(0).getValidator().check(value, c) ) {
            throw new ValidateException();
        }
    }
    public void updateDisplay(Bind bind, Object component, Object value) {
        Collection collection = (Collection)value;
        JList list = (JList)component;
        
        list.setModel(new JListBoxModel(list, collection, bind));
        list.updateUI();
    }
    public void updateComponent(Bind bind, Object component) {
    }
    public void selectBean(Bind bind, Object component, Object[] bean) {
        JList list = (JList)component;
        JListBoxModel model = (JListBoxModel)list.getModel();
        
        List indices = new ArrayList();//List<Integer>
        for(int k=0; k<bean.length; k++) {
            Object obj = bean[k];
            for(int i=0; i<model.bean.size(); i++) {
                if( model.bean.toArray()[i].equals(obj) ) {
                    indices.add( new Integer(i) );
                }
            }
        }
        
        int[] arrayIndices = new int[indices.size()];
        for(int i=0; i<indices.size(); i++) {
            arrayIndices[i] = ((Integer)indices.get(i)).intValue();
        }
        list.setSelectedIndices( arrayIndices );
    }
    public Object[] getSelectedBean(Bind bind, Object component) {
        JList list = (JList)component;
        JListBoxModel model = (JListBoxModel)list.getModel();
        int[] indices = list.getSelectedIndices();
        if( indices.length <= 0 )return null;
        
        Object[] results = new Object[indices.length];
        for(int i=0; i<indices.length; i++) {
            try {
                results[i] = BeanProcessBridge.getPropertyValue(model.bean.toArray()[indices[i]],
                        bind.getProperty(0).getDataSrc().getValueProp()
                );
            }catch(Exception e) {
                throw new RuntimeException(e);
            }
        }
        return results;
    }
    public void setEditable(Bind bind, Object component) {
    }
    public Object getValue(Bind bind, Object component) {
        return this.getSelectedBean(bind, component);
    }
}
