package jp.sf.beanbinder.strategy.swing;

import javax.swing.JRadioButton;

import jp.sf.beanbinder.Bind;
import jp.sf.beanbinder.strategy.AbsComponentStrategy;



public final class JRadioButtonStrategy extends AbsComponentStrategy {

    public void updateDisplay(Bind bind, Object component, Object value) {
        try {
            Object obj = (value==null?"":value.toString());
            ((JRadioButton)component).setSelected( Boolean.parseBoolean(obj.toString()) );
        }catch(Exception e) {
            throw new RuntimeException(e);
        }
    }
    public void updateComponent(Bind bind, Object component) {
    }
    public void setEditable(Bind bind, Object component) {
        JRadioButton check = (JRadioButton)component;
        check.setEnabled(bind.getProperty(0).isEditable());
    }
    public Object getValue(Bind bind, Object component) {
        JRadioButton check = (JRadioButton)component;
        return new Boolean(check.isSelected());
    }
    
}
