package jp.sf.beanbinder.strategy.swing;

import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

import jp.sf.beanbinder.Bind;
import jp.sf.beanbinder.BindProperty;
import jp.sf.beanbinder.editor.CellEditor;
import jp.sf.beanbinder.editor.swing.SwingCellEditor;
import jp.sf.beanbinder.exception.ValidateException;
import jp.sf.beanbinder.strategy.ComponentStrategy;



public final class JTableStrategy implements ComponentStrategy, MultiSelectable {

    public void updateBean(Object bean, Bind bind, Object component) {
        try {
            this.validate(bind, component);
        }catch(Exception e) {
            throw new RuntimeException(e);
        }
    }
    public void validate(Bind bind, Object component) throws ValidateException {
      JTable table = (JTable)bind.getComponent();
      JTableModel model = (JTableModel)this.getTableModel(table);
    
      for(int row=0; row<table.getRowCount(); row++) {
          for(int column=0; column<table.getColumnCount(); column++) {
              Object value = model.getProperty(row, column);
              try {
                  model.setValueAt(value, row, column);
              }catch(Exception e) {
                  throw new RuntimeException(e);
              }
          }
      }
    }
    
    public void updateDisplay(Bind bind, Object component, Object value) {
        Collection collection = (Collection)value;
        JTable table = (JTable)component;
        AbstractTableModel oldModel = (AbstractTableModel)table.getModel();
        if( oldModel instanceof TableSorter ) {
            oldModel = (AbstractTableModel)((TableSorter)oldModel).getTableModel();
        }
        JTableModel newModel = new JTableModel(table, collection, bind);
        //リスナーの引継ぎ
        for(int i=0; i<oldModel.getTableModelListeners().length; i++) {
            TableModelListener listener = oldModel.getTableModelListeners()[i];
            newModel.addTableModelListener(listener);
        }
        for(int i=0; i<newModel.getTableModelListeners().length; i++) {
            TableModelListener listener = newModel.getTableModelListeners()[i];
            oldModel.removeTableModelListener(listener);
        }
        
        //ソートするか？
        if( bind.isSortable() ) {
            TableSorter sorter = new TableSorter(newModel);//((JTableModel)newModel).getSorter();
            table.setModel(sorter);
            sorter.setTableHeader(table.getTableHeader());
        }else {
            table.setModel(newModel);
        }        
        
        for( int i=0; i<bind.getProperties().size(); i++ ) {
            //行の高さを設定
            BindProperty prop = bind.getProperty(i);
            table.setRowHeight(prop.getHeight());
            
            //列の横幅を設定
            table.getColumn(table.getColumnName(i)).setPreferredWidth(prop.getWidth());
            
            //セルエディタの設定
            CellEditor editor = (CellEditor)prop.getColumnProperty().getCellEditor();
            if( editor == null ) {
                final JTextField txt = new JTextField();
                txt.setBorder(null);
                prop.getColumnProperty().setCellEditor(editor);
                
                editor = new CellEditor() {
                    public Object getComponent() {
                        return txt;
                    }
                    public Object getCellEditorValue() {
                        return ((JTextField)this.getComponent()).getText();
                    }
                    public void updateCellEditor(Object value, int row, int col) {
                        ((JTextField)this.getComponent()).setText((value==null?"":value.toString()));
                    }                    
                };
                
                FocusListener[] listeners = txt.getFocusListeners();
                for(int k=0; k<listeners.length; k++) {
                    FocusListener fl = listeners[k];
                    if(fl instanceof IMEFocusListener)txt.removeFocusListener(fl);
                }
                txt.addFocusListener(new IMEFocusListener(bind.getProperty(i)));
            }
            table.getColumnModel().getColumn(i).setCellEditor(new SwingCellEditor(newModel, collection, bind, editor));
        }
        
        //更新
        table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(bind, collection));
        table.updateUI();
    }
    public void updateComponent(Bind bind, Object component) {
    }
    public void selectBean(Bind bind, Object component, Object[] bean) {
        JTable table = (JTable)component;
        JTableModel model = (JTableModel)this.getTableModel(table);
        
        List indices = new ArrayList();//List<Integer>
        for(int k=0; k<bean.length; k++) {
            Object obj = bean[k];
            for(int i=0; i<model.bean.size(); i++) {
                if( model.bean.toArray()[i].equals(obj) ) {
                    indices.add(new Integer(i));
                }
            }
        }

        if( indices.size() > 0 ) {
            table.setRowSelectionInterval(
                    ((Integer)indices.get(0)).intValue(),
                    ((Integer)indices.get(0)).intValue()
            );
        }
    }
    public Object[] getSelectedBean(Bind bind, Object component) {
        return (Object[])this.getValue(bind, component);
    }
    public void setEditable(Bind bind, Object component) {
        JTable table = (JTable)component;
        JTableModel model = (JTableModel)this.getTableModel(table);
        model.bind = bind;
    }
    public Object getValue(Bind bind, Object component) {
        JTable table = (JTable)component;
        JTableModel model = (JTableModel)this.getTableModel(table);
        int[] indices = table.getSelectedRows();
        if( indices.length <= 0 )return null;
        
        Object[] results = new Object[indices.length];
        for(int i=0; i<indices.length; i++) {
            results[i] = model.bean.toArray()[indices[i]];
        }
        return results;
    }
    
    private JTableModel getTableModel(JTable table) {
        if( table.getModel() instanceof TableSorter ) {
            return (JTableModel)((TableSorter)table.getModel()).getTableModel();
        }
        return (JTableModel)table.getModel();
    }
}
