package jp.sf.beanbinder.strategy.swing;

import java.awt.event.FocusListener;

import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

import jp.sf.beanbinder.AlignType;
import jp.sf.beanbinder.Bind;
import jp.sf.beanbinder.strategy.AbsComponentStrategy;

public final class JTextComponentStrategy extends AbsComponentStrategy {
    private IMEFocusListener imeFocusListener;
    
    public void updateDisplay(Bind bind, Object component, Object value) {
        try {
            JTextComponent textComponent = (JTextComponent)component;
            textComponent.setText( (value==null?"":value.toString()) );            
            this.updateComponent(bind, component);
        }catch(Exception e) {
            throw new RuntimeException(e);
        }
    }
    public void updateComponent(Bind bind, Object component) {
        JTextComponent textComponent = (JTextComponent)component;
        
        FocusListener[] listeners = textComponent.getFocusListeners();
        for(int i=0; i<listeners.length; i++) {
            FocusListener fl = listeners[i];
            if(fl instanceof IMEFocusListener)textComponent.removeFocusListener(fl);
        }
        //IME
        if( this.imeFocusListener != null )textComponent.removeFocusListener(this.imeFocusListener);
        this.imeFocusListener = new IMEFocusListener(bind.getProperty(0));
        textComponent.addFocusListener(this.imeFocusListener);
        
        //Align
        if( textComponent instanceof JTextField ) {
            int align = JTextField.LEFT;
            if( bind.getProperty(0).getHorizon().equals(AlignType.LEFT) )align=JTextField.LEFT;
            if( bind.getProperty(0).getHorizon().equals(AlignType.CENTER) )align=JTextField.CENTER;
            if( bind.getProperty(0).getHorizon().equals(AlignType.RIGHT) )align=JTextField.RIGHT;
            ((JTextField)textComponent).setHorizontalAlignment(align);
        }
    }
    public void setEditable(Bind bind, Object component) {
        ((JTextComponent)component).setEditable(bind.getProperty(0).isEditable());
    }
    public Object getValue(Bind bind, Object component) {
        return ((JTextComponent)component).getText();
    }
    
}
