package jp.sf.beanbinder.swing;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;

import jp.sf.beanbinder.BindStrategyDispatcher;
import jp.sf.beanbinder.ComponentStrategyPlug;
import jp.sf.beanbinder.component.swing.DateBox;
import jp.sf.beanbinder.component.swing.PictureBox;
import jp.sf.beanbinder.strategy.swing.DateBoxStrategy;
import jp.sf.beanbinder.strategy.swing.JCheckBoxStrategy;
import jp.sf.beanbinder.strategy.swing.JComboBoxStrategy;
import jp.sf.beanbinder.strategy.swing.JLabelStrategy;
import jp.sf.beanbinder.strategy.swing.JListBoxStrategy;
import jp.sf.beanbinder.strategy.swing.JRadioButtonStrategy;
import jp.sf.beanbinder.strategy.swing.JTableStrategy;
import jp.sf.beanbinder.strategy.swing.JTextComponentStrategy;
import jp.sf.beanbinder.strategy.swing.PictureBoxStrategy;


/**
 * BeanBinderのSwing実装
 */
public class SwingImpl extends BindStrategyDispatcher {
    public SwingImpl() {
        this.addComponentStrategyPlug( new ComponentStrategyPlug(JTextComponent.class, new JTextComponentStrategy()) );
        this.addComponentStrategyPlug( new ComponentStrategyPlug(JLabel.class, new JLabelStrategy()) );
        this.addComponentStrategyPlug( new ComponentStrategyPlug(JComboBox.class, new JComboBoxStrategy()) );
        this.addComponentStrategyPlug( new ComponentStrategyPlug(JList.class, new JListBoxStrategy()) );
        this.addComponentStrategyPlug( new ComponentStrategyPlug(JTable.class, new JTableStrategy()) );
        this.addComponentStrategyPlug( new ComponentStrategyPlug(JRadioButton.class, new JRadioButtonStrategy()) );
        this.addComponentStrategyPlug( new ComponentStrategyPlug(JCheckBox.class, new JCheckBoxStrategy()) );
        this.addComponentStrategyPlug( new ComponentStrategyPlug(PictureBox.class, new PictureBoxStrategy()) );
        this.addComponentStrategyPlug( new ComponentStrategyPlug(DateBox.class, new DateBoxStrategy()) );      
    }
}
