package jp.sf.beanbinder.util;

import java.sql.Time;

import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;

public final class BeanProcessBridge {
    public static Object getPropertyValue(Object bean, String propertyPath) throws Exception {
        if( bean == null )return null;
        if( propertyPath == null || propertyPath.trim().length() <= 0 )return bean;
        Object value = null;
        
        try {
            value = PropertyUtils.getProperty(bean, propertyPath);
        }
        catch(NestedNullException e) {
            return null;
        }
        catch(Exception e) {
            try {
                value = FieldUtils.getField(bean, propertyPath);
            }catch(Exception e2) {
                System.out.println("指定したプロパティが見つかりません。:"+bean.getClass().getName()+"."+propertyPath);
            }
        }
        return value;
    }
    public static void setPropertyValue(Object bean, String propertyPath, Object value) throws Exception {
        Class type = null;
        if( propertyPath == null ) {
            type = bean.getClass();
        }else {
            type = PropertyUtils.getPropertyType(bean, propertyPath);
        }
        if( type == null ) {
            type = FieldUtils.getFieldType(bean, propertyPath);
        }
        Object fmtValue=value;
        
        //Should I refactor this?
        if( type.isPrimitive() ) {
            fmtValue =  BeanProcessBridge.convertPrimitive(value, type);
        }
        else if( type.getSuperclass() != null && type.getSuperclass().equals(Number.class) ) {
            try {
                String normVal = value.toString().replaceAll("[,]", "");
                fmtValue = type.getConstructor(new Class[]{String.class}).newInstance(new Object[]{normVal});
            }catch(Exception e) {
                fmtValue = type.getConstructor(new Class[]{String.class}).newInstance(new Object[]{"0"});
            }
        }
        else if( type.equals(Time.class) ) {
            Integer h=new Integer(0), m=new Integer(0), s=new Integer(0);
            String[] args = value.toString().split("[:]");
            if( args.length >= 1 ) { h = new Integer(args[0]); }
            if( args.length >= 2 ) { m = new Integer(args[1]); }
            if( args.length >= 3 ) { s = new Integer(args[2]); }
            fmtValue = type.getConstructor(new Class[]{int.class,int.class,int.class}).newInstance(new Object[]{h,m,s});
        }
        else if( type.equals(Boolean.class) ) {
            fmtValue = type.getConstructor(new Class[]{String.class}).newInstance(new Object[]{value.toString()});
        }
        
        try {
            PropertyUtils.setProperty(bean, propertyPath, fmtValue);
        }catch(Exception e) {
            FieldUtils.setField(bean, propertyPath, fmtValue);
        }
    }
    private static Object convertPrimitive(Object primitive, Class type) {
        if( type.equals(int.class) || type.equals(long.class) ||
                type.equals(short.class) || type.equals(byte.class) || type.equals(float.class) ||
                type.equals(double.class) ) {
            primitive = primitive.toString().replaceAll("[,]", "");
        }
            
        if( type.equals(int.class) ) { return new Integer(primitive.toString()); }
        if( type.equals(short.class) ) { return new Short(primitive.toString()); }
        if( type.equals(float.class) ) { return new Float(primitive.toString()); }
        if( type.equals(double.class) ) { return new Double(primitive.toString()); }
        if( type.equals(long.class) ) { return new Long(primitive.toString()); }
        if( type.equals(boolean.class) ) { return new Boolean(primitive.toString()); }
        if( type.equals(byte.class) ) { return new Byte(primitive.toString()); }
        if( type.equals(char.class) ) { return new Character(primitive.toString().charAt(0)); }
        
        throw new RuntimeException();
    }
}
