package jp.sf.beanbinder.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;

public final class FieldUtils {
    public static Object getField(Object bean, String fieldPath) throws Exception {
        String[] fields = fieldPath.split("[.]");
        
        Object currBean = bean;
        for(int i=0; i<fields.length; i++) {
            String field = fields[i];
            Field f = currBean.getClass().getField(field);
            AccessibleObject.setAccessible(new Field[]{f}, true);
            
            currBean = f.get(currBean);
        }
        return currBean;
    }
    public static void setField(Object bean, String fieldPath, Object value) throws Exception {
        String[] fields = fieldPath.split("[.]");
        
        Object currBean = bean;
        for(int i=0; i<fields.length; i++) {
            String field = fields[i];
            Field f = currBean.getClass().getField(field);
            AccessibleObject.setAccessible(new Field[]{f}, true);
            
            if( i != fields.length-1 ) {
                currBean = f.get(currBean);
            }else {
                f.set(currBean, value);
            }
        }        
    }
    public static Class getFieldType(Object bean, String fieldPath) throws Exception {
        String[] fields = fieldPath.split("[.]");
        
        Object currBean = bean;
        for(int i=0; i<fields.length; i++) {
            String field = fields[i];
            Field f = currBean.getClass().getField(field);
            AccessibleObject.setAccessible(new Field[]{f}, true);
            
            if( i != fields.length-1 ) {
                currBean = f.get(currBean);
            }else {
                return f.getType();
            }
        }
        return null;
    }
    
}
