package jp.sf.beanbinder.validator;

import java.math.BigDecimal;


public class LeValidator extends Validator {
    private BigDecimal value;
    
    /**
     * @deprecated
     */
    public LeValidator(){}
    public LeValidator(Number value, String errorMessage, ValidateDisplay display) {
        super(errorMessage, display);
        this.value = new BigDecimal(value.doubleValue());
    }
    public ValidateResult checkValue(Object value, Object component) {
        try {
            BigDecimal number = new BigDecimal(value.toString());
            if( this.value == null )return ValidateResult.FAIL();
            if( number.doubleValue() < this.value.doubleValue() )return ValidateResult.FAIL();
            return ValidateResult.SUCCESS();
        }catch(Exception e) {
            return ValidateResult.FAIL();
        }
    }
    public BigDecimal getValue() {
        return value;
    }
    public void setValue(BigDecimal value) {
        this.value = value;
    }
}
