package jp.sf.beanbinder.validator;


public class LengthValidator extends Validator {
    private Integer min;
    private Integer max;
    
    /**
     * @deprecated
     */
    public LengthValidator(){}
    public LengthValidator(Integer min, Integer max, String errorMessage, ValidateDisplay display) {
        super(errorMessage, display);
        this.min = min;
        this.max = max;
    }
    public LengthValidator(Integer max, String errorMessage, ValidateDisplay display) {
        this(null, max, errorMessage, display);
    }
    public ValidateResult checkValue(Object value, Object component) {
        String data = value.toString();
        if( this.min != null ) {
            if( data.length() < this.min.doubleValue() || data.length() > this.max.doubleValue() )return ValidateResult.FAIL();
        }else {
            if( data.length() > this.max.doubleValue() )return ValidateResult.FAIL();
        }
        return ValidateResult.SUCCESS();
    }
    public Integer getMax() {
        return max;
    }
    public void setMax(Integer max) {
        this.max = max;
    }
    public Integer getMin() {
        return min;
    }
    public void setMin(Integer min) {
        this.min = min;
    }
    
}
