package jp.sf.beanbinder.validator;

import java.math.BigDecimal;


public class RangeValidator extends Validator {
    private BigDecimal min;
    private BigDecimal max;
    
    /**
     * @deprecated
     */
    public RangeValidator(){}
    public RangeValidator(Number min, Number max, String errorMessage, ValidateDisplay display) {
        super(errorMessage, display);
        this.min = new BigDecimal(min.doubleValue());
        this.max = new BigDecimal(max.doubleValue());
    }
    public ValidateResult checkValue(Object value, Object component) {
        try {
            BigDecimal number = new BigDecimal(value.toString());
            if( this.min != null ) {
                if( number.doubleValue() < this.min.doubleValue() || number.doubleValue() > this.max.doubleValue() )return ValidateResult.FAIL();
            }else {
                if( number.doubleValue() > this.max.doubleValue() )return ValidateResult.FAIL();
            }
            return ValidateResult.SUCCESS();
        }catch(Exception e) {
            return ValidateResult.FAIL();
        }
    }
    public BigDecimal getMax() {
        return max;
    }
    public void setMax(BigDecimal max) {
        this.max = max;
    }
    public BigDecimal getMin() {
        return min;
    }
    public void setMin(BigDecimal min) {
        this.min = min;
    }
    
}
