package jp.sf.beanbinder.validator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ValidateContainer extends DefaultValidator {
    private List validators = new ArrayList();//List<Validator>

    /**
     * @return List<Validator>
     */
    public List getValidators() {
        return validators;
    }
    /**
     * @param validator (List<Validator>)
     */
    public void setValidators(List validator) {
        this.validators = validator;
    }
    public void addValidator(Validator validator) {
        this.validators.add(validator);
    }
    public void removeValidator(Validator validator) {
        this.validators.remove(validator);
    }
    public ValidateResult checkValue(Object value, Object component) {
        Iterator itr = this.getValidators().iterator();
        while(itr.hasNext()) {
            Validator validator = (Validator)itr.next();
            if( !validator.check(value, component) ) {
                return ValidateResult.FAIL();
            }
        }
        return ValidateResult.SUCCESS();
    }
}
