package jp.sf.beanbinder.validator;


public abstract class Validator {
    private ValidateDisplay display;
    private String errorMessage;
    
    /**
     * @deprecated
     */
    public Validator(){}
    public Validator(String errorMessage, ValidateDisplay display) {
        if( display == null )throw new RuntimeException("ValidateDisplayにnullが指定されました。");
        this.errorMessage = errorMessage;
        this.display = display;
    }
    public abstract ValidateResult checkValue(Object value, Object component);
    public boolean check(Object value, Object component) {
        this.display.update("");
        boolean result = this.checkValue(value, component).equals(ValidateResult.SUCCESS());
        if( !result ) {
            this.display.update(this.errorMessage);
        }
        return result;
    }
    public ValidateDisplay getDisplay() {
        return display;
    }
    public void setDisplay(ValidateDisplay display) {
        this.display = display;
    }
    public String getErrorMessage() {
        return errorMessage;
    }
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
    
}
