/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.beanbinder;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import jp.sf.beanbinder.AlignType;
import jp.sf.beanbinder.BeanBinder;
import jp.sf.beanbinder.Bind;
import jp.sf.beanbinder.BindProperty;
import jp.sf.beanbinder.CellRenderer;
import jp.sf.beanbinder.DefaultFormat;
import jp.sf.beanbinder.IMEMode;
import jp.sf.beanbinder.Ref;
import jp.sf.beanbinder.editor.CellEditor;
import jp.sf.beanbinder.listener.EditListener;
import jp.sf.beanbinder.validator.Validator;

public final class BindingBridge {
    private Object target;
    private Field[] fields;
    private BeanBinder binder;
    static /* synthetic */ Class class$0;

    public BindingBridge(BeanBinder binder, Object target) {
        this.target = target;
        this.binder = binder;
        ArrayList results = new ArrayList();
        this.parseFields(results, target.getClass());
        this.fields = results.toArray(new Field[0]);
        AccessibleObject.setAccessible(this.fields, true);
    }

    private void parseFields(List fields, Class currentClass) {
        if (currentClass == null) {
            return;
        }
        Field[] fs = currentClass.getDeclaredFields();
        int i = 0;
        while (i < fs.length) {
            Field f = fs[i];
            fields.add(f);
            ++i;
        }
        this.parseFields(fields, currentClass.getSuperclass());
    }

    public Field getField(Object target, String field) throws Exception {
        int i = 0;
        while (i < this.fields.length) {
            Field f = this.fields[i];
            if (field.equals(f.getName())) {
                return f;
            }
            ++i;
        }
        throw new RuntimeException("\u6307\u5b9a\u3057\u305f\u30d5\u30a3\u30fc\u30eb\u30c9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002:" + field);
    }

    public Object getFieldValue(Object target, String field) throws Exception {
        if (field == null || field.trim().length() <= 0) {
            return null;
        }
        Field f = this.getField(target, field);
        return f.get(target);
    }

    public Object getConstValue(String fieldName) throws Exception {
        if (fieldName == null || fieldName.length() <= 0) {
            return null;
        }
        String[] split = fieldName.split("[.]");
        String path = "";
        int i = 1;
        while (i < split.length) {
            path = String.valueOf(path) + split[i];
            if (i != split.length - 1) {
                path = String.valueOf(path) + ".";
            }
            ++i;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sf.beanbinder.BeanBinder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Package pack = clazz.getPackage();
        try {
            Field field = Class.forName(String.valueOf(pack.getName()) + "." + split[0]).getField(path);
            return field.get(null);
        }
        catch (Exception e) {
            throw new Exception("\u6307\u5b9a\u3057\u305f\u30d5\u30a3\u30fc\u30eb\u30c9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002:" + fieldName);
        }
    }

    public void bindBasic(String fieldName, String objectId, String prop, String group, IMEMode imeMode, Format format, AlignType horizon, AlignType vertical, Validator validator) throws Exception {
        Object component = this.getFieldValue(this.target, fieldName);
        Bind bind = new Bind(objectId, component);
        bind.setGroup(group);
        BindProperty bp = new BindProperty(prop, new Ref(prop));
        bp.setImeMode(imeMode);
        bp.setFormat(format == null ? new DefaultFormat() : format);
        bp.setHorizon(horizon == null ? AlignType.LEFT : horizon);
        bp.setVertical(vertical == null ? AlignType.TOP : vertical);
        bp.setValidator(validator);
        bind.addProperty(bp);
        this.binder.bind(fieldName, bind);
    }

    public void bindSelect(String fieldName, String group, String destId, String destValueProp, String destIdProp, String srcId, String srcDisplayProp, String srcValueProp, String srcIdProp, Format format, AlignType horizon, AlignType vertical, Validator validator) throws Exception {
        Object component = this.getFieldValue(this.target, fieldName);
        Bind bind = new Bind(destId, component);
        bind.setDataSource(srcId);
        bind.setGroup(group);
        BindProperty bp = new BindProperty(srcDisplayProp, new Ref(destValueProp, destIdProp), new Ref(srcValueProp, srcIdProp));
        bp.setFormat(format == null ? new DefaultFormat() : format);
        bp.setHorizon(horizon == null ? AlignType.LEFT : horizon);
        bp.setVertical(vertical == null ? AlignType.TOP : vertical);
        bp.setValidator(validator);
        bind.addProperty(bp);
        this.binder.bind(fieldName, bind);
    }

    public void bindCustom(String fieldName, String objectId, String displayProp, String idProp, String group, IMEMode imeMode, Format format, AlignType horizon, AlignType vertical, Validator validator) throws Exception {
        Object component = this.getFieldValue(this.target, fieldName);
        Bind bind = new Bind(objectId, component);
        bind.setGroup(group);
        BindProperty bp = new BindProperty(displayProp, new Ref(objectId, idProp));
        bp.setImeMode(imeMode);
        bp.setFormat(format == null ? new DefaultFormat() : format);
        bp.setHorizon(horizon == null ? AlignType.LEFT : horizon);
        bp.setVertical(vertical == null ? AlignType.TOP : vertical);
        bp.setValidator(validator);
        bind.addProperty(bp);
        this.binder.bind(fieldName, bind);
    }

    public void bindTable(String fieldName, String objectId, String group, int rowHeight, boolean sortable, EditListener editListener, BindProperty[] columns) throws Exception {
        Object component = this.getFieldValue(this.target, fieldName);
        Bind bind = new Bind(objectId, component);
        bind.setSortable(sortable);
        bind.setEditListener(editListener);
        int i = 0;
        while (i < columns.length) {
            BindProperty col = columns[i];
            if (rowHeight <= 0) {
                rowHeight = 20;
            }
            col.setHeight(rowHeight);
            bind.addProperty(col);
            ++i;
        }
        this.binder.bind(fieldName, bind);
    }

    public BindProperty bindColumn(String displayProp, String valueProp, String idProp, String text, boolean readOnly, String prop, int width, IMEMode imeMode, Format format, AlignType horizon, AlignType vertical, Validator validator, CellEditor cellEditor, CellRenderer cellRenderer) throws Exception {
        BindProperty col = new BindProperty(displayProp, new Ref(valueProp, idProp));
        if (prop != null && prop.length() > 0) {
            col.getRef().setValueProp(prop);
            col.setDisplayProperty(prop);
        }
        col.getColumnProperty().setText(text);
        col.setEditable(!readOnly);
        col.setWidth(width);
        col.setImeMode(imeMode);
        col.setFormat(format == null ? new DefaultFormat() : format);
        col.setHorizon(horizon == null ? AlignType.LEFT : horizon);
        col.setVertical(vertical == null ? AlignType.TOP : vertical);
        col.setValidator(validator);
        col.getColumnProperty().setCellEditor(cellEditor);
        col.getColumnProperty().setCellRenderer(cellRenderer);
        return col;
    }
}

