/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.beanbinder.strategy.swing;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.im.InputSubset;
import jp.sf.beanbinder.BindProperty;
import jp.sf.beanbinder.IMEMode;

public class IMEFocusListener
implements FocusListener {
    private BindProperty element;

    public IMEFocusListener(BindProperty element) {
        this.element = element;
    }

    public void focusGained(FocusEvent e) {
        Component cmp = (Component)e.getSource();
        if (cmp == null) {
            return;
        }
        if (this.element.getImeMode().equals(IMEMode.DEFAULT)) {
            if (cmp.getInputContext() != null) {
                cmp.getInputContext().setCharacterSubsets(null);
            }
        } else if (this.element.getImeMode().equals(IMEMode.JP)) {
            cmp.getInputContext().setCharacterSubsets(new Character.Subset[]{InputSubset.KANJI});
        } else if (this.element.getImeMode().equals(IMEMode.HALFKANA)) {
            cmp.getInputContext().setCharacterSubsets(new Character.Subset[]{InputSubset.HALFWIDTH_KATAKANA});
        }
    }

    public void focusLost(FocusEvent e) {
        Component cmp = (Component)e.getSource();
        if (cmp == null) {
            return;
        }
        if (cmp.getInputContext() != null) {
            cmp.getInputContext().setCharacterSubsets(null);
        }
    }
}

