/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import model.Employee;
import model.ItemDetail;
import model.Product;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Order {
    private Long id;
    private String code;
    private Date orderedDate;
    private Employee employee;
    private List<ItemDetail> itemDetails = new ArrayList<ItemDetail>();
    private BigDecimal taxRate = new BigDecimal(0.05);

    public BigDecimal getTotalPrice() {
        BigDecimal totalPrice = new BigDecimal(0);
        for (ItemDetail itemDetail : this.getItemDetails()) {
            totalPrice = totalPrice.add(itemDetail.getTotalPrice());
        }
        return totalPrice;
    }

    public BigDecimal getTax() {
        return this.getTotalPrice().multiply(this.getTaxRate()).setScale(0, 1);
    }

    public BigDecimal getGross() {
        return this.getTotalPrice().add(this.getTax());
    }

    public void addItemDetail(Product product, BigDecimal qty) {
        this.itemDetails.add(new ItemDetail(product, qty));
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public List<ItemDetail> getItemDetails() {
        return this.itemDetails;
    }

    public void setItemDetails(List<ItemDetail> itemDetails) {
        this.itemDetails = itemDetails;
    }

    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getOrderedDate() {
        return this.orderedDate;
    }

    public void setOrderedDate(Date orderedDate) {
        this.orderedDate = orderedDate;
    }
}

