package component;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import jp.sf.beanbinder.BeanBinder;
import jp.sf.beanbinder.BeanBinderFactory;
import jp.sf.beanbinder.annotations.AnnotationParser;
import jp.sf.beanbinder.annotations.Basic;
import jp.sf.beanbinder.annotations.IMEMode;

public class AddressBox extends JPanel {
    public BeanBinder binder = BeanBinderFactory.createSwingBinder();
    
    @Basic( objectKey="bean", prop="postcode" )
    private JTextField postcodeTxt = null;
    
    @Basic( objectKey="bean", prop="province", imeMode=IMEMode.JP )
    private JTextField provinceTxt = null;
    
    @Basic( objectKey="bean", prop="city", imeMode=IMEMode.JP )
    private JTextField cityTxt = null;
    
    @Basic( objectKey="bean", prop="street", imeMode=IMEMode.JP )
    private JTextField streetTxt = null;
    
    @Basic( objectKey="bean", prop="bldg", imeMode=IMEMode.JP )
    private JTextField bldgTxt = null;
    
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel11 = null;
    private JLabel jLabel12 = null;
    private JLabel jLabel121 = null;

    /**
     * This method initializes 
     * 
     */
    public AddressBox() {
    	super();
    	initialize();
        
        new AnnotationParser(this.binder, this).parse();
    }

    /**
     * This method initializes this
     * 
     */
    private void initialize() {
        jLabel121 = new JLabel();
        jLabel121.setBounds(new Rectangle(10, 130, 61, 21));
        jLabel121.setText("ビル建物");
        jLabel121.setHorizontalAlignment(SwingConstants.CENTER);
        jLabel12 = new JLabel();
        jLabel12.setBounds(new Rectangle(10, 100, 61, 21));
        jLabel12.setText("町域番地");
        jLabel12.setHorizontalAlignment(SwingConstants.CENTER);
        jLabel11 = new JLabel();
        jLabel11.setBounds(new Rectangle(10, 70, 61, 21));
        jLabel11.setText("市区町村");
        jLabel11.setHorizontalAlignment(SwingConstants.CENTER);
        jLabel1 = new JLabel();
        jLabel1.setBounds(new Rectangle(10, 40, 61, 21));
        jLabel1.setText("都道府県");
        jLabel1.setHorizontalAlignment(SwingConstants.CENTER);
        jLabel = new JLabel();
        jLabel.setBounds(new Rectangle(10, 10, 61, 21));
        jLabel.setHorizontalAlignment(SwingConstants.CENTER);
        jLabel.setText("郵便番号");
        this.setLayout(null);
        this.setSize(new Dimension(321, 162));
        this.setPreferredSize(new Dimension(321, 162));
        this.setBorder(BorderFactory.createLineBorder(Color.blue, 1));
        this.setBackground(new Color(200, 232, 255));
        this.add(getPostcodeTxt(), null);
        this.add(jLabel, null);
        this.add(jLabel1, null);
        this.add(getProvinceTxt(), null);
        this.add(jLabel11, null);
        this.add(getCityTxt(), null);
        this.add(jLabel12, null);
        this.add(getStreetTxt(), null);
        this.add(jLabel121, null);
        this.add(getBldgTxt(), null);
    		
    }

    /**
     * This method initializes postcodeTxt	
     * 	
     * @return javax.swing.JTextField	
     */
    public JTextField getPostcodeTxt() {
        if (postcodeTxt == null) {
            postcodeTxt = new JTextField();
            postcodeTxt.setBounds(new Rectangle(80, 10, 81, 21));
        }
        return postcodeTxt;
    }

    /**
     * This method initializes provinceTxt	
     * 	
     * @return javax.swing.JTextField	
     */
    public JTextField getProvinceTxt() {
        if (provinceTxt == null) {
            provinceTxt = new JTextField();
            provinceTxt.setBounds(new Rectangle(80, 40, 131, 21));
        }
        return provinceTxt;
    }

    /**
     * This method initializes cityTxt	
     * 	
     * @return javax.swing.JTextField	
     */
    public JTextField getCityTxt() {
        if (cityTxt == null) {
            cityTxt = new JTextField();
            cityTxt.setBounds(new Rectangle(80, 70, 231, 21));
        }
        return cityTxt;
    }

    /**
     * This method initializes streetTxt	
     * 	
     * @return javax.swing.JTextField	
     */
    public JTextField getStreetTxt() {
        if (streetTxt == null) {
            streetTxt = new JTextField();
            streetTxt.setBounds(new Rectangle(80, 100, 231, 21));
        }
        return streetTxt;
    }

    /**
     * This method initializes bldgTxt	
     * 	
     * @return javax.swing.JTextField	
     */
    public JTextField getBldgTxt() {
        if (bldgTxt == null) {
            bldgTxt = new JTextField();
            bldgTxt.setBounds(new Rectangle(80, 130, 231, 21));
        }
        return bldgTxt;
    }

}  //  @jve:decl-index=0:visual-constraint="10,10"
