package component;

import jp.sf.beanbinder.BeanBinder;
import jp.sf.beanbinder.editor.GeneralCellEditor;
import jp.sf.beanbinder.exception.ValidateException;

public class AddressCellEditor extends GeneralCellEditor {
    public AddressCellEditor(BeanBinder binder, Object component) {
        super(binder, component);
    }
    public Object getCellEditorValue(BeanBinder binder) {
        AddressBox addressBox = (AddressBox)this.getComponent();
        try {
            binder.updateObject("bean");
            return binder.getObject("bean");
        }catch(ValidateException e) {
            throw new RuntimeException(e);
        }
    }
    public void updateCellEditor(BeanBinder binder, Object value, int row, int col) {
        AddressBox addressBox = (AddressBox)this.getComponent();
        binder.setObject("bean", value);
        binder.updateComponent(".*");
    }
}
