package examples;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;

public class Boot extends JFrame implements ActionListener {
    private JButton cmbExampleBtn = new JButton("コンボボックスサンプル");
    private JButton txtExampleBtn = new JButton("テキストボックスサンプル");
    private JButton radioExampleBtn = new JButton("ラジオボタンサンプル");
    private JButton dateExampleBtn = new JButton("日付オブジェクトサンプル");
    private JButton tableExampleBtn = new JButton("テーブルサンプル");
    private JButton customComponentExampleBtn = new JButton("カスタムコンポーネントサンプル");
    private JButton customComponentExampleBtn2 = new JButton("カスタムコンポーネントサンプル２");
    private JButton customComponentExampleBtn3 = new JButton("カスタムコンポーネントサンプル３");
    
    public Boot() {
        this.setTitle("Example");
        this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        this.setSize(320, 300);
        this.setLayout(null);
        
        JButton btns[] = {txtExampleBtn,radioExampleBtn,dateExampleBtn,cmbExampleBtn,tableExampleBtn,customComponentExampleBtn,customComponentExampleBtn2,customComponentExampleBtn3};
        int y=10;
        for(JButton btn : btns) {
            btn.setBounds(10, y, 280, 20);
            this.add(btn);
            btn.addActionListener(this);
            y += 30;
        }
    }
    public void actionPerformed(ActionEvent e) {
        if( e.getActionCommand().equals("テキストボックスサンプル") ) {
            new TextBoxExample().setVisible(true);
        }
        if( e.getActionCommand().equals("ラジオボタンサンプル") ) {
            new RadioButtonExample().setVisible(true);
        }
        if( e.getActionCommand().equals("日付オブジェクトサンプル") ) {
            new DateExample().setVisible(true);
        }
        if( e.getActionCommand().equals("コンボボックスサンプル") ) {
            new ComboBoxExample().setVisible(true);
        }
        if( e.getActionCommand().equals("テーブルサンプル") ) {
            new TableExample().setVisible(true);
        }
        if( e.getActionCommand().equals("カスタムコンポーネントサンプル") ) {
            new CustomComponentExample().setVisible(true);
        }
        if( e.getActionCommand().equals("カスタムコンポーネントサンプル２") ) {
            new CustomComponentExample2().setVisible(true);
        }
        if( e.getActionCommand().equals("カスタムコンポーネントサンプル３") ) {
            new CustomComponentExample3().setVisible(true);
        }
    }
    public static void main(String[] args) {
        new Boot().setVisible(true);
    }
}
