package examples;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

import jp.sf.beanbinder.BeanBinder;
import jp.sf.beanbinder.BeanBinderFactory;
import jp.sf.beanbinder.annotations.AnnotationParser;
import jp.sf.beanbinder.annotations.Select;
import jp.sf.beanbinder.exception.ValidateException;
import model.Employee;
import model.Order;

public class ComboBoxExample extends JFrame implements ActionListener {
    public BeanBinder binder = BeanBinderFactory.createSwingBinder();
    
    @Select( destKey="target", destValueProp="employee", destIdProp="employee.id",
            srcKey="empList", srcDisplayProp="name", srcValueProp="", srcIdProp="id"
    )
    private JComboBox cmb;
    
    public ComboBoxExample() {
        this.setTitle("ComboBox");
        this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        this.setSize(640, 480);
        this.setLayout(null);
    
        //データソース
        List<Employee> employeeList = new ArrayList<Employee>();
        Employee employee = new Employee();
        employee.setId(new Long(1));
        employee.setName("山田 太郎");
        employeeList.add(employee);
        
        employee = new Employee();
        employee.setId(new Long(2));
        employee.setName("吉田 花子");
        employeeList.add(employee);
        
        //データソースとして登録
        this.binder.setObject("empList", employeeList);
        
        //ターゲット（受注）
        Order order = new Order();
        this.binder.setObject("target", order);
        
        //コンポーネントの配置
        this.cmb = new JComboBox();
        this.cmb.setBounds(10, 10, 240, 20);
        this.add(this.cmb);
        
        //アノテーションからマッピング
        new AnnotationParser(this.binder, this).parse();

        //リスナーの追加
        this.cmb.addActionListener(this);
        
        //画面の再描画
        this.binder.updateComponent(".*");
    }
    public void actionPerformed(ActionEvent e) {
        //選択しているオブジェクトを取得する場合
        Employee employee = (Employee)this.binder.getSelectedValue("cmb");
        if( employee == null )return;
        
        //選択しているオブジェクトからターゲットを更新する場合
        try {
            this.binder.updateObject("target");
            Order order = (Order)this.binder.getObject("target");
            
            //更新後の結果を表示
            JOptionPane.showMessageDialog(this,
                    "氏名:"+order.getEmployee().getName(),
                    "オブジェクトは更新されました",
                    JOptionPane.INFORMATION_MESSAGE );
        }catch(ValidateException ex) {
            ex.printStackTrace();
        }
    }
    public static void main(String[] args) {
        new ComboBoxExample().setVisible(true);
    }
}