package examples;

import javax.swing.JFrame;

import jp.sf.beanbinder.BeanBinder;
import jp.sf.beanbinder.BeanBinderFactory;
import jp.sf.beanbinder.ComponentStrategyPlug;
import jp.sf.beanbinder.annotations.AnnotationParser;
import jp.sf.beanbinder.annotations.Basic;
import model.Employee;

import component.AddressBox;
import component.AddressBoxStrategy;

public class CustomComponentExample extends JFrame {
    public BeanBinder binder = BeanBinderFactory.createSwingBinder();
    
    @Basic( objectKey="emp", prop="address" )
    private AddressBox addressBox;
    
    public CustomComponentExample() {
        this.setTitle("カスタムコンポーネントのサンプル");
        this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        this.setSize(640, 480);
        this.setLayout(null);
    
        //BeanBinderの生成とBinding実装にカスタムコンポーネントを追加
        ComponentStrategyPlug plug = new ComponentStrategyPlug(AddressBox.class, new AddressBoxStrategy()); 
        this.binder.getBindStrategyDisplatcher().addComponentStrategyPlug(plug);
        
        //オリジナルのコンポーネントを配置
        this.addressBox = new AddressBox();
        this.addressBox.setBounds(10, 10, 320, 240);
        this.add(this.addressBox);
        
        //サンプルオブジェクト
        Employee employee = new Employee();
        employee.setName("山田 太郎");
        employee.getAddress().setPostcode("000-0000");
        employee.getAddress().setProvince("大阪府");
        employee.getAddress().setCity("どこそこ市なになに町");
        employee.getAddress().setStreet("1-23-456");
        employee.getAddress().setBldg("");
        this.binder.setObject("emp", employee);
        
        //アノテーションからマッピング
        new AnnotationParser(this.binder, this).parse();
        
        //画面の再描画
        this.binder.updateComponent("addressBox");
    }
    public static void main(String[] args) {
        new CustomComponentExample().setVisible(true);
    }
}
