package examples;

import java.awt.BorderLayout;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

import jp.sf.beanbinder.BeanBinder;
import jp.sf.beanbinder.BeanBinderFactory;
import jp.sf.beanbinder.BindProperty;
import jp.sf.beanbinder.CellRenderer;
import jp.sf.beanbinder.ComponentStrategyPlug;
import jp.sf.beanbinder.annotations.AlignType;
import jp.sf.beanbinder.annotations.AnnotationParser;
import jp.sf.beanbinder.annotations.Basic;
import jp.sf.beanbinder.annotations.Column;
import jp.sf.beanbinder.annotations.Table;
import jp.sf.beanbinder.editor.CellEditor;
import jp.sf.beanbinder.editor.GeneralCellEditor;
import model.Employee;
import model.ItemDetail;
import model.Order;
import model.Product;

import component.AddressBox;
import component.AddressBoxStrategy;

public class CustomComponentExample3 extends JFrame {
    public BeanBinder binder = BeanBinderFactory.createSwingBinder();
    
    private Format fmt1 = DateFormat.getDateInstance(DateFormat.SHORT);
    private Format fmt2 = new DecimalFormat("###,###,###");
    
    @Table( objectKey="orderList", sortable=true, rowHeight=80,
            columns={
                @Column( prop="code", text="受注コード", readOnly=true ),
                @Column( prop="orderedDate", text="受注日", formatField="fmt1", readOnly=true ),
                @Column( prop="employee.name", text="担当者", readOnly=true ),
                @Column( prop="totalPrice", text="小計", formatField="fmt2", horizon=AlignType.RIGHT, readOnly=true ),
                @Column( prop="tax", text="消費税", formatField="fmt2", horizon=AlignType.RIGHT, readOnly=true ),
                @Column( prop="gross", text="請求金額", formatField="fmt2", horizon=AlignType.RIGHT, readOnly=true ),
                @Column( prop="itemDetails", text="明細行",
                        cellEditorField="cellEditor1",
                        cellRendererField="cellRenderer1",
                        width=480 )
            }
    )
    private JTable tbl;
    
    @Table( objectKey="bean", sortable=true,
            columns={
                @Column( prop="product.name", text="品名", readOnly=true ),
                @Column( prop="product.unitPrice", text="単価", formatField="fmt2", horizon=AlignType.RIGHT, readOnly=true ),
                @Column( prop="qty", text="数量", formatField="fmt2", horizon=AlignType.RIGHT, readOnly=true ),
                @Column( prop="totalPrice", text="合計", formatField="fmt2", horizon=AlignType.RIGHT, readOnly=true )
            }
    )
    private JTable tbl2 = new JTable();
    private CellEditor cellEditor1 = new GeneralCellEditor(this.binder, new JScrollPane(tbl2)) {
        public Object getCellEditorValue(BeanBinder binder) {
            return binder.getObject("bean");
        }
        public void updateCellEditor(BeanBinder binder, Object value, int row, int col) {
            binder.setObject("bean", value);
            binder.updateComponent("tbl2");
        }
    };
    
    @Basic(objectKey="bean", prop="", horizon=AlignType.CENTER)
    private JLabel lbl = new JLabel();
    private CellRenderer cellRenderer1 = new CellRenderer(this.binder, lbl) {
        public void update(BeanBinder binder, BindProperty property, Object displayValue, Object value, int row, int column) {
            List<ItemDetail> itemDetails = (List<ItemDetail>)value;
            binder.setObject("bean", itemDetails.size()+"行");
            binder.updateComponent("lbl");
        }        
    };
    
    public CustomComponentExample3() {
        this.setTitle("TableBox");
        this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        this.setSize(640, 480);
        this.setLayout(new BorderLayout());
        Format format;
        //BeanBinderの生成とBinding実装にカスタムコンポーネントを追加
        ComponentStrategyPlug plug = new ComponentStrategyPlug(AddressBox.class, new AddressBoxStrategy()); 
        this.binder.getBindStrategyDisplatcher().addComponentStrategyPlug(plug);
        
        //コンポーネントの配置
        this.tbl = new JTable();
        this.add(new JScrollPane(tbl), BorderLayout.CENTER);
        
        //サンプルオブジェクト
        List<Order> orderList = new ArrayList<Order>();
        Order order = new Order();
        order.setCode("A00201");
        order.setOrderedDate(new Date());
        order.setEmployee(new Employee("テスト太郎"));
        order.addItemDetail(new Product("おせんべい", new BigDecimal(230)), new BigDecimal(5));
        order.addItemDetail(new Product("ジュース", new BigDecimal(110)), new BigDecimal(2));
        orderList.add(order);
        
        order = new Order();
        order.setCode("A00202");
        order.setOrderedDate(new Date());
        order.setEmployee(new Employee("テスト花子"));
        order.addItemDetail(new Product("チョコレート", new BigDecimal(230)), new BigDecimal(2));
        order.addItemDetail(new Product("シャンプー", new BigDecimal(1024)), new BigDecimal(1));
        order.addItemDetail(new Product("雑誌", new BigDecimal(500)), new BigDecimal(1));
        orderList.add(order);
        
        order = new Order();
        order.setCode("A00203");
        order.setOrderedDate(new Date());
        order.setEmployee(new Employee("ジョン"));
        order.addItemDetail(new Product("寿司", new BigDecimal(500)), new BigDecimal(1));
        order.addItemDetail(new Product("ビール", new BigDecimal(270)), new BigDecimal(2));
        orderList.add(order);
        
        this.binder.setObject("orderList", orderList);
        
        
        //アノテーションからマッピング
        new AnnotationParser(this.binder, this).parse();
        
        //画面の再描画
        this.binder.updateComponent(".*");
    }
    public static void main(String[] args) {
        new CustomComponentExample3().setVisible(true);
    }
}