package examples;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

import jp.sf.beanbinder.BeanBinder;
import jp.sf.beanbinder.BeanBinderFactory;
import jp.sf.beanbinder.annotations.AnnotationParser;
import jp.sf.beanbinder.annotations.Select;
import jp.sf.beanbinder.exception.ValidateException;
import model.Employee;
import model.Order;

public class ListBoxExample extends JFrame implements MouseListener {
    public BeanBinder binder = BeanBinderFactory.createSwingBinder();
    
    @Select( destKey="target", destValueProp="employee", destIdProp="employee.id",
            srcKey="empList", srcDisplayProp="name", srcValueProp="", srcIdProp="id"
    )
    private JList list;
    
    public ListBoxExample() {
        this.setTitle("ListBox");
        this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        this.setSize(640, 480);
        this.setLayout(null);
    
        //データソース
        List<Employee> employeeList = new ArrayList<Employee>();
        Employee employee = new Employee();
        employee.setId(new Long(1));
        employee.setName("山田 太郎");
        employeeList.add(employee);
        
        employee = new Employee();
        employee.setId(new Long(2));
        employee.setName("吉田 花子");
        employeeList.add(employee);
        
        //データソースとして登録
        this.binder.setObject("empList", employeeList);
        
        //ターゲット（受注）
        Order order = new Order();
        this.binder.setObject("target", order);
        
        //コンポーネントの配置
        this.list = new JList();
        Component comp = new JScrollPane( this.list );
        comp.setBounds(10, 10, 240, 100);
        this.add(comp);
        
        //アノテーションからマッピング
        new AnnotationParser(this.binder, this).parse();

        //リスナーの追加
        this.list.addMouseListener(this);
        
        //画面の再描画
        this.binder.updateComponent(".*");
    }
    public void mouseClicked(MouseEvent e) {        
        try {
            this.binder.updateObject("target");
            Order order = (Order)this.binder.getObject("target");
            
            //更新後の結果を表示
            JOptionPane.showMessageDialog(this,
                    "氏名:"+order.getEmployee().getName(),
                    "オブジェクトは更新されました",
                    JOptionPane.INFORMATION_MESSAGE );
        }catch(ValidateException ex) {
            ex.printStackTrace();
        }
        
        
//        //選択しているオブジェクトを取得する場合
//        Employee employee = (Employee)this.binder.getSelectedValue("cmb");
//        if( employee == null )return;
//        
//        //選択しているオブジェクトからターゲットを更新する場合
//        try {
//            this.binder.updateObject("target");
//            Order order = (Order)this.binder.getObject("target");
//            
//            //更新後の結果を表示
//            JOptionPane.showMessageDialog(this,
//                    "氏名:"+order.getEmployee().getName(),
//                    "オブジェクトは更新されました",
//                    JOptionPane.INFORMATION_MESSAGE );
//        }catch(ValidateException ex) {
//            ex.printStackTrace();
//        }        
    }
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}

    public static void main(String[] args) {
        new ListBoxExample().setVisible(true);
    }
}