package examples;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;

import jp.sf.beanbinder.BeanBinder;
import jp.sf.beanbinder.BeanBinderFactory;
import jp.sf.beanbinder.annotations.AnnotationParser;
import jp.sf.beanbinder.annotations.Basic;
import jp.sf.beanbinder.exception.ValidateException;
import model.Employee;

public class RadioButtonExample extends JFrame implements ActionListener {
    public BeanBinder binder = BeanBinderFactory.createSwingBinder();
    
    @Basic( objectKey="emp", prop="sex" )
    private JRadioButton radio1;
    private JRadioButton radio2;
    
    public RadioButtonExample() {
        this.setTitle("RadioButton");
        this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        this.setSize(640, 480);
        this.setLayout(null);
    
        //コンポーネントの配置
        this.radio1 = new JRadioButton("男性");
        this.radio1.setBounds(10, 10, 240, 20);
        this.add(this.radio1);
        
        this.radio2 = new JRadioButton("女性");
        this.radio2.setBounds(10, 40, 240, 20);
        this.add(this.radio2);
        
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.radio1);
        grp.add(this.radio2);
        
        //サンプルオブジェクト
        Employee employee = new Employee();
        employee.setSex(true);
        this.binder.setObject("emp", employee);
        
        //アノテーションからマッピング
        new AnnotationParser(this.binder, this).parse();
        
        //リスナーの追加
        this.radio1.addActionListener(this);
        this.radio2.addActionListener(this);
        
        //画面の再描画
        this.binder.updateComponent(".*");
    }
    public void actionPerformed(ActionEvent e) {
        try {
            //オブジェクトの更新
            this.binder.updateObject("emp");
            Employee employee = (Employee)this.binder.getObject("emp");
            
            //更新後の結果を表示
            JOptionPane.showMessageDialog(this,
                    "性別:"+(employee.isSex()?"男性":"女性"),
                    "オブジェクトは更新されました",
                    JOptionPane.INFORMATION_MESSAGE );
        }catch(ValidateException ex) {
            ex.printStackTrace();
        }
    }
    public static void main(String[] args) {
        new RadioButtonExample().setVisible(true);
    }
}